/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CompositeTestDescriptorVisitor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public interface TestDescriptor {
    public UniqueId getUniqueId();

    public String getDisplayName();

    default public String getLegacyReportingName() {
        return this.getDisplayName();
    }

    public Set<TestTag> getTags();

    public Optional<TestSource> getSource();

    public Optional<TestDescriptor> getParent();

    public void setParent(@Nullable TestDescriptor var1);

    public Set<? extends TestDescriptor> getChildren();

    @API(status=API.Status.STABLE, since="1.10")
    default public Set<? extends TestDescriptor> getAncestors() {
        if (this.getParent().isEmpty()) {
            return Collections.emptySet();
        }
        TestDescriptor parent = this.getParent().get();
        LinkedHashSet<? extends TestDescriptor> ancestors = new LinkedHashSet<TestDescriptor>();
        ancestors.add(parent);
        if (parent.getParent().isPresent()) {
            ancestors.addAll(parent.getAncestors());
        }
        return Collections.unmodifiableSet(ancestors);
    }

    default public Set<? extends TestDescriptor> getDescendants() {
        LinkedHashSet<TestDescriptor> descendants = new LinkedHashSet<TestDescriptor>();
        descendants.addAll(this.getChildren());
        for (TestDescriptor testDescriptor : this.getChildren()) {
            descendants.addAll(testDescriptor.getDescendants());
        }
        return Collections.unmodifiableSet(descendants);
    }

    public void addChild(TestDescriptor var1);

    public void removeChild(TestDescriptor var1);

    public void removeFromHierarchy();

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    default public void orderChildren(UnaryOperator<List<TestDescriptor>> orderer) {
        Preconditions.notNull(orderer, "orderer must not be null");
        Set<? extends TestDescriptor> originalChildren = this.getChildren();
        List suggestedOrder = (List)orderer.apply(new ArrayList<TestDescriptor>(originalChildren));
        Preconditions.notNull(suggestedOrder, "orderer may not return null");
        LinkedHashSet orderedChildren = new LinkedHashSet(suggestedOrder);
        boolean unmodified = originalChildren.equals(orderedChildren);
        Preconditions.condition(unmodified && originalChildren.size() == suggestedOrder.size(), "orderer may not add or remove test descriptors");
        suggestedOrder.stream().distinct().filter(originalChildren::contains).forEach(testDescriptor -> {
            this.removeChild((TestDescriptor)testDescriptor);
            this.addChild((TestDescriptor)testDescriptor);
        });
    }

    default public boolean isRoot() {
        return this.getParent().isEmpty();
    }

    public Type getType();

    default public boolean isContainer() {
        return this.getType().isContainer();
    }

    default public boolean isTest() {
        return this.getType().isTest();
    }

    default public boolean mayRegisterTests() {
        return false;
    }

    public static boolean containsTests(TestDescriptor testDescriptor) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        return testDescriptor.isTest() || testDescriptor.mayRegisterTests() || testDescriptor.getChildren().stream().anyMatch(TestDescriptor::containsTests);
    }

    default public void prune() {
        if (!this.isRoot() && !TestDescriptor.containsTests(this)) {
            this.removeFromHierarchy();
        }
    }

    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId var1);

    default public void accept(Visitor visitor) {
        Preconditions.notNull(visitor, "Visitor must not be null");
        visitor.visit(this);
        new LinkedHashSet<TestDescriptor>(this.getChildren()).forEach(child -> child.accept(visitor));
    }

    public static enum Type {
        CONTAINER,
        TEST,
        CONTAINER_AND_TEST;


        public boolean isContainer() {
            return this == CONTAINER || this == CONTAINER_AND_TEST;
        }

        public boolean isTest() {
            return this == TEST || this == CONTAINER_AND_TEST;
        }
    }

    @FunctionalInterface
    public static interface Visitor {
        @API(status=API.Status.EXPERIMENTAL, since="6.0")
        public static Visitor composite(Visitor ... visitors) {
            return CompositeTestDescriptorVisitor.from(visitors);
        }

        public void visit(TestDescriptor var1);
    }
}

