/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringJoiner;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvRecord;

public final class NamedCsvRecord
extends CsvRecord {
    private final String[] header;

    NamedCsvRecord(long startingLineNumber, String[] fields, boolean comment, String[] header) {
        super(startingLineNumber, fields, comment);
        this.header = header;
    }

    public List<String> getHeader() {
        return Collections.unmodifiableList(Arrays.asList(this.header));
    }

    public String getField(String name) {
        int fieldIdx = this.findHeaderIndex(name);
        if (fieldIdx == -1) {
            throw new NoSuchElementException("Header does not contain a field '%s'. Valid names are: %s".formatted(name, Arrays.toString(this.header)));
        }
        if (fieldIdx >= this.fields.length) {
            throw new NoSuchElementException("Field '%s' is on index %d, but current record only contains %d fields".formatted(name, fieldIdx, this.fields.length));
        }
        return this.fields[fieldIdx];
    }

    private int findHeaderIndex(String name) {
        for (int i2 = 0; i2 < this.header.length; ++i2) {
            if (!name.equals(this.header[i2])) continue;
            return i2;
        }
        return -1;
    }

    public Optional<String> findField(String name) {
        int fieldIdx = this.findHeaderIndex(name);
        if (fieldIdx == -1 || fieldIdx >= this.fields.length) {
            return Optional.empty();
        }
        return Optional.of(this.fields[fieldIdx]);
    }

    public List<String> findFields(String name) {
        int bound = this.header.length;
        ArrayList<String> ret = new ArrayList<String>(bound);
        for (int i2 = 0; i2 < bound; ++i2) {
            if (!name.equals(this.header[i2])) continue;
            ret.add(this.fields[i2]);
        }
        return ret;
    }

    public Map<String, String> getFieldsAsMap() {
        int bound = this.commonSize();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(bound);
        for (int i2 = 0; i2 < bound; ++i2) {
            map.putIfAbsent(this.header[i2], this.fields[i2]);
        }
        return map;
    }

    public Map<String, List<String>> getFieldsAsMapList() {
        int bound = this.commonSize();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(bound);
        for (int i2 = 0; i2 < bound; ++i2) {
            String key = this.header[i2];
            ArrayList<String> val = (ArrayList<String>)map.get(key);
            if (val == null) {
                val = new ArrayList<String>();
                map.put(key, val);
            }
            val.add(this.fields[i2]);
        }
        return map;
    }

    private int commonSize() {
        return Math.min(this.header.length, this.fields.length);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NamedCsvRecord.class.getSimpleName() + "[", "]").add("startingLineNumber=" + this.startingLineNumber).add("fields=" + Arrays.toString(this.fields)).add("comment=" + this.comment).add("header=" + Arrays.toString(this.header)).toString();
    }
}

