/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.AnnotatedElementContext;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.params.ArgumentSetLifecycleMethod;
import org.junit.jupiter.params.EvaluatedArgumentSet;
import org.junit.jupiter.params.Parameter;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.ParameterizedTestSpiInstantiator;
import org.junit.jupiter.params.ResolutionCache;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.aggregator.ArgumentsAccessor;
import org.junit.jupiter.params.aggregator.ArgumentsAggregationException;
import org.junit.jupiter.params.aggregator.ArgumentsAggregator;
import org.junit.jupiter.params.aggregator.SimpleArgumentsAggregator;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.jupiter.params.support.FieldContext;
import org.junit.jupiter.params.support.ParameterDeclaration;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.jupiter.params.support.ParameterInfo;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.KotlinReflectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class ResolverFacade {
    private final int parameterIndexOffset;
    private final Map<ParameterDeclaration, Resolver> resolvers;
    private final DefaultParameterDeclarations indexedParameterDeclarations;
    private final Set<? extends ResolvableParameterDeclaration> aggregatorParameters;

    static ResolverFacade create(Class<?> clazz, List<Field> fields) {
        Preconditions.notEmpty(fields, "Fields must not be empty");
        TreeMap<Integer, List<FieldParameterDeclaration>> allIndexedParameters = new TreeMap<Integer, List<FieldParameterDeclaration>>();
        LinkedHashSet<FieldParameterDeclaration> aggregatorParameters = new LinkedHashSet<FieldParameterDeclaration>();
        for (Field field : fields) {
            Parameter annotation = AnnotationSupport.findAnnotation(field, Parameter.class).orElseThrow(() -> new JUnitException("No @Parameter annotation present"));
            int index = annotation.value();
            FieldParameterDeclaration declaration2 = new FieldParameterDeclaration(field, annotation.value());
            if (declaration2.isAggregator()) {
                aggregatorParameters.add(declaration2);
                continue;
            }
            if (fields.size() == 1 && index == -1) {
                index = 0;
                declaration2 = new FieldParameterDeclaration(field, 0);
            }
            allIndexedParameters.computeIfAbsent(index, __ -> new ArrayList()).add(declaration2);
        }
        NavigableMap<Integer, FieldParameterDeclaration> uniqueIndexedParameters = ResolverFacade.validateFieldDeclarations(allIndexedParameters, aggregatorParameters);
        Stream.concat(uniqueIndexedParameters.values().stream(), aggregatorParameters.stream()).forEach(declaration -> ReflectionSupport.makeAccessible(declaration.getField()));
        return new ResolverFacade(clazz, uniqueIndexedParameters, aggregatorParameters, 0);
    }

    static ResolverFacade create(Constructor<?> constructor, ParameterizedClass annotation) {
        int implicitParameters = ReflectionUtils.isInnerClass(constructor.getDeclaringClass()) ? 1 : 0;
        return ResolverFacade.create(constructor, annotation, implicitParameters);
    }

    static ResolverFacade create(Method method, Annotation annotation) {
        if (KotlinReflectionUtils.isKotlinSuspendingFunction(method)) {
            return ResolverFacade.create(method, annotation, 0, KotlinReflectionUtils.getKotlinSuspendingFunctionParameters(method));
        }
        return ResolverFacade.create(method, annotation, 0);
    }

    private static ResolverFacade create(Executable executable, Annotation annotation, int indexOffset) {
        return ResolverFacade.create(executable, annotation, indexOffset, executable.getParameters());
    }

    private static ResolverFacade create(Executable executable, Annotation annotation, int indexOffset, java.lang.reflect.Parameter[] parameters) {
        TreeMap<Integer, ExecutableParameterDeclaration> indexedParameters = new TreeMap<Integer, ExecutableParameterDeclaration>();
        TreeMap<Integer, ExecutableParameterDeclaration> aggregatorParameters = new TreeMap<Integer, ExecutableParameterDeclaration>();
        for (int index = indexOffset; index < parameters.length; ++index) {
            ExecutableParameterDeclaration declaration = new ExecutableParameterDeclaration(parameters[index], index, indexOffset);
            if (declaration.isAggregator()) {
                Preconditions.condition(aggregatorParameters.isEmpty() || (Integer)aggregatorParameters.lastKey() == declaration.getParameterIndex() - 1, () -> String.format("@%s %s declares formal parameters in an invalid order: argument aggregators must be declared after any indexed arguments and before any arguments resolved by another ParameterResolver.", annotation.annotationType().getSimpleName(), DefaultParameterDeclarations.describe(executable)));
                aggregatorParameters.put(declaration.getParameterIndex(), declaration);
                continue;
            }
            if (!aggregatorParameters.isEmpty()) continue;
            indexedParameters.put(declaration.getParameterIndex(), declaration);
        }
        return new ResolverFacade(executable, indexedParameters, new LinkedHashSet(aggregatorParameters.values()), indexOffset);
    }

    private ResolverFacade(AnnotatedElement sourceElement, NavigableMap<Integer, ? extends ResolvableParameterDeclaration> indexedParameters, Set<? extends ResolvableParameterDeclaration> aggregatorParameters, int parameterIndexOffset) {
        this.aggregatorParameters = aggregatorParameters;
        this.parameterIndexOffset = parameterIndexOffset;
        this.resolvers = new ConcurrentHashMap<ParameterDeclaration, Resolver>(indexedParameters.size() + aggregatorParameters.size());
        this.indexedParameterDeclarations = new DefaultParameterDeclarations(sourceElement, indexedParameters);
    }

    ParameterDeclarations getIndexedParameterDeclarations() {
        return this.indexedParameterDeclarations;
    }

    boolean isSupportedParameter(ParameterContext parameterContext, EvaluatedArgumentSet arguments) {
        int index = this.toLogicalIndex(parameterContext);
        if (this.indexedParameterDeclarations.get(index).isPresent()) {
            return index < arguments.getConsumedLength();
        }
        return !this.aggregatorParameters.isEmpty() && this.aggregatorParameters.stream().anyMatch(it -> it.getParameterIndex() == index);
    }

    Optional<String> getParameterName(int parameterIndex) {
        return this.indexedParameterDeclarations.get(parameterIndex).flatMap(ParameterDeclaration::getParameterName);
    }

    int determineConsumedArgumentLength(int totalLength) {
        NavigableMap<Integer, ? extends ResolvableParameterDeclaration> declarationsByIndex = this.indexedParameterDeclarations.declarationsByIndex;
        return this.aggregatorParameters.isEmpty() ? Math.min(totalLength, declarationsByIndex.isEmpty() ? 0 : (Integer)declarationsByIndex.lastKey() + 1) : totalLength;
    }

    int determineConsumedArgumentCount(EvaluatedArgumentSet arguments) {
        if (this.aggregatorParameters.isEmpty()) {
            return this.indexedParameterDeclarations.declarationsByIndex.subMap(0, arguments.getConsumedLength()).size();
        }
        return arguments.getTotalLength();
    }

    ArgumentSetLifecycleMethod.ParameterResolver createLifecycleMethodParameterResolver(Method method, Annotation annotation) {
        ResolverFacade originalResolverFacade = this;
        ResolverFacade lifecycleMethodResolverFacade = ResolverFacade.create(method, annotation);
        HashMap<ParameterDeclaration, ResolvableParameterDeclaration> parameterDeclarationMapping = new HashMap<ParameterDeclaration, ResolvableParameterDeclaration>();
        List<String> errors = ResolverFacade.validateLifecycleMethodParameters(method, annotation, originalResolverFacade, lifecycleMethodResolverFacade, parameterDeclarationMapping);
        return Try.call(() -> ResolverFacade.configurationErrorOrSuccess(errors, () -> new DefaultArgumentSetLifecycleMethodParameterResolver(originalResolverFacade, lifecycleMethodResolverFacade, parameterDeclarationMapping))).getNonNullOrThrow(cause -> new ExtensionConfigurationException("Invalid @%s lifecycle method declaration: %s".formatted(annotation.annotationType().getSimpleName(), method.toGenericString()), (Throwable)cause));
    }

    @Nullable Object resolve(ParameterContext parameterContext, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, ResolutionCache resolutionCache) {
        int parameterIndex = this.toLogicalIndex(parameterContext);
        ResolvableParameterDeclaration declaration = this.findDeclaration(parameterIndex).orElseThrow(() -> new ParameterResolutionException("Parameter index out of bounds: " + parameterIndex));
        return resolutionCache.resolve(declaration, () -> this.resolve(declaration, extensionContext, arguments, invocationIndex, Optional.of(parameterContext)));
    }

    private Optional<? extends ResolvableParameterDeclaration> findDeclaration(int parameterIndex) {
        ResolvableParameterDeclaration declaration = (ResolvableParameterDeclaration)this.indexedParameterDeclarations.declarationsByIndex.get(parameterIndex);
        if (declaration == null) {
            return this.aggregatorParameters.stream().filter(it -> it.getParameterIndex() == parameterIndex).findFirst();
        }
        return Optional.of(declaration);
    }

    void resolveAndInjectFields(Object testInstance, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, ResolutionCache resolutionCache) {
        if (this.indexedParameterDeclarations.sourceElement.equals(testInstance.getClass())) {
            this.getAllParameterDeclarations().filter(FieldParameterDeclaration.class::isInstance).map(FieldParameterDeclaration.class::cast).forEach(declaration -> this.setField(testInstance, (FieldParameterDeclaration)declaration, extensionContext, arguments, invocationIndex, resolutionCache));
        }
    }

    private Stream<ParameterDeclaration> getAllParameterDeclarations() {
        return Stream.concat(this.indexedParameterDeclarations.declarationsByIndex.values().stream(), this.aggregatorParameters.stream());
    }

    private void setField(Object testInstance, FieldParameterDeclaration declaration, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, ResolutionCache resolutionCache) {
        Object argument = resolutionCache.resolve(declaration, () -> this.resolve(declaration, extensionContext, arguments, invocationIndex, Optional.empty()));
        try {
            declaration.getField().set(testInstance, argument);
        }
        catch (Exception e) {
            throw new JUnitException("Failed to inject parameter value into field: " + String.valueOf(declaration.getField()), e);
        }
    }

    private @Nullable Object resolve(ResolvableParameterDeclaration parameterDeclaration, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, Optional<ParameterContext> parameterContext) {
        Resolver resolver = this.getResolver(extensionContext, parameterDeclaration);
        return parameterDeclaration.resolve(resolver, extensionContext, arguments, invocationIndex, parameterContext);
    }

    private Resolver getResolver(ExtensionContext extensionContext, ResolvableParameterDeclaration declaration) {
        return this.resolvers.computeIfAbsent(declaration, __ -> this.aggregatorParameters.contains(declaration) ? ResolverFacade.createAggregator(declaration, extensionContext) : ResolverFacade.createConverter(declaration, extensionContext));
    }

    private int toLogicalIndex(ParameterContext parameterContext) {
        int index = parameterContext.getIndex() - this.parameterIndexOffset;
        Preconditions.condition(index >= 0, () -> "Parameter index must be greater than or equal to zero");
        return index;
    }

    private static NavigableMap<Integer, FieldParameterDeclaration> validateFieldDeclarations(NavigableMap<Integer, List<FieldParameterDeclaration>> indexedParameters, Set<FieldParameterDeclaration> aggregatorParameters) {
        ArrayList<String> errors = new ArrayList<String>();
        ResolverFacade.validateIndexedParameters(indexedParameters, errors);
        ResolverFacade.validateAggregatorParameters(aggregatorParameters, errors);
        return ResolverFacade.configurationErrorOrSuccess(errors, () -> indexedParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (FieldParameterDeclaration)((List)entry.getValue()).get(0), (d, __) -> d, TreeMap::new)));
    }

    private static List<String> validateLifecycleMethodParameters(Method method, Annotation annotation, ResolverFacade originalResolverFacade, ResolverFacade lifecycleMethodResolverFacade, Map<ParameterDeclaration, ResolvableParameterDeclaration> parameterDeclarationMapping) {
        List<ParameterDeclaration> actualDeclarations = lifecycleMethodResolverFacade.indexedParameterDeclarations.getAll();
        ArrayList<String> errors = new ArrayList<String>();
        for (int parameterIndex = 0; parameterIndex < actualDeclarations.size(); ++parameterIndex) {
            ParameterDeclaration actualDeclaration = actualDeclarations.get(parameterIndex);
            ResolvableParameterDeclaration originalDeclaration = (ResolvableParameterDeclaration)originalResolverFacade.indexedParameterDeclarations.declarationsByIndex.get(parameterIndex);
            if (originalDeclaration == null) break;
            if (!actualDeclaration.getParameterType().equals(originalDeclaration.getParameterType())) {
                errors.add("parameter%s with index %d is incompatible with the parameter declared on the parameterized class: expected type '%s' but found '%s'".formatted(ResolverFacade.parameterName(actualDeclaration), parameterIndex, originalDeclaration.getParameterType(), actualDeclaration.getParameterType()));
                continue;
            }
            if (AnnotationSupport.findAnnotation(actualDeclaration.getAnnotatedElement(), ConvertWith.class).isPresent()) {
                errors.add("parameter%s with index %d must not be annotated with @ConvertWith".formatted(ResolverFacade.parameterName(actualDeclaration), parameterIndex));
                continue;
            }
            if (!errors.isEmpty()) continue;
            parameterDeclarationMapping.put(actualDeclaration, originalDeclaration);
        }
        return errors;
    }

    private static String parameterName(ParameterDeclaration actualDeclaration) {
        return actualDeclaration.getParameterName().map(name -> " '" + name + "'").orElse("");
    }

    private static <T> T configurationErrorOrSuccess(List<String> errors, Supplier<T> successfulResult) {
        if (errors.isEmpty()) {
            return successfulResult.get();
        }
        if (errors.size() == 1) {
            throw new PreconditionViolationException("Configuration error: " + errors.get(0) + ".");
        }
        throw new PreconditionViolationException("%d configuration errors:%n%s".formatted(errors.size(), errors.stream().collect(Collectors.joining(System.lineSeparator() + "- ", "- ", ""))));
    }

    private static void validateIndexedParameters(NavigableMap<Integer, List<FieldParameterDeclaration>> indexedParameters, List<String> errors) {
        if (indexedParameters.isEmpty()) {
            return;
        }
        indexedParameters.forEach((index, declarations) -> ResolverFacade.validateIndexedParameterDeclarations(index, declarations, errors));
        for (int index2 = 0; index2 <= (Integer)indexedParameters.lastKey(); ++index2) {
            if (indexedParameters.containsKey(index2)) continue;
            errors.add("no field annotated with @Parameter(%d) declared".formatted(index2));
        }
    }

    private static void validateIndexedParameterDeclarations(int index, List<FieldParameterDeclaration> declarations, List<String> errors) {
        List<Field> fields = declarations.stream().map(FieldParameterDeclaration::getField).toList();
        if (index < 0) {
            declarations.stream().map(declaration -> "index must be greater than or equal to zero in @Parameter(%d) annotation on field [%s]".formatted(index, declaration.getField())).forEach(errors::add);
        } else if (declarations.size() > 1) {
            errors.add("duplicate index declared in @Parameter(%d) annotation on fields %s".formatted(index, fields));
        }
        String string = "@Parameter field [%s] must not be declared as final";
        fields.stream().filter(ModifierSupport::isFinal).map(arg_0 -> ResolverFacade.lambda$validateIndexedParameterDeclarations$1("@Parameter field [%s] must not be declared as final", arg_0)).forEach(errors::add);
    }

    private static void validateAggregatorParameters(Set<FieldParameterDeclaration> aggregatorParameters, List<String> errors) {
        aggregatorParameters.stream().filter(declaration -> declaration.getParameterIndex() != -1).map(declaration -> "no index may be declared in @Parameter(%d) annotation on aggregator field [%s]".formatted(declaration.getParameterIndex(), declaration.getField())).forEach(errors::add);
    }

    private static Converter createConverter(ParameterDeclaration declaration, ExtensionContext extensionContext) {
        try {
            return AnnotationSupport.findAnnotation(declaration.getAnnotatedElement(), ConvertWith.class).map(ConvertWith::value).map(clazz -> ParameterizedTestSpiInstantiator.instantiate(ArgumentConverter.class, clazz, extensionContext)).map(converter -> AnnotationConsumerInitializer.initialize(declaration.getAnnotatedElement(), converter)).map(Converter::new).orElseGet(() -> Converter.createDefault(extensionContext));
        }
        catch (Exception ex) {
            throw ResolverFacade.parameterResolutionException("Error creating ArgumentConverter", ex, declaration.getParameterIndex());
        }
    }

    private static Aggregator createAggregator(ParameterDeclaration declaration, ExtensionContext extensionContext) {
        try {
            return AnnotationSupport.findAnnotation(declaration.getAnnotatedElement(), AggregateWith.class).map(AggregateWith::value).map(clazz -> ParameterizedTestSpiInstantiator.instantiate(ArgumentsAggregator.class, clazz, extensionContext)).map(Aggregator::new).orElse(Aggregator.DEFAULT);
        }
        catch (Exception ex) {
            throw ResolverFacade.parameterResolutionException("Error creating ArgumentsAggregator", ex, declaration.getParameterIndex());
        }
    }

    private static ParameterResolutionException parameterResolutionException(String message, Exception cause, int index) {
        String fullMessage = message + " at index " + index;
        if (StringUtils.isNotBlank(cause.getMessage())) {
            fullMessage = fullMessage + ": " + cause.getMessage();
        }
        return new ParameterResolutionException(fullMessage, cause);
    }

    private static /* synthetic */ String lambda$validateIndexedParameterDeclarations$1(String rec$, Object xva$0) {
        return "@Parameter field [%s] must not be declared as final".formatted(xva$0);
    }

    private static class FieldParameterDeclaration
    extends ResolvableParameterDeclaration
    implements FieldContext {
        private final Field field;
        private final int index;

        FieldParameterDeclaration(Field field, int index) {
            this.field = field;
            this.index = index;
        }

        @Override
        public Field getField() {
            return this.field;
        }

        @Override
        public Field getAnnotatedElement() {
            return this.field;
        }

        @Override
        public Class<?> getParameterType() {
            return this.field.getType();
        }

        @Override
        public int getParameterIndex() {
            return this.index;
        }

        @Override
        public Optional<String> getParameterName() {
            return Optional.of(this.field.getName());
        }

        @Override
        public @Nullable Object resolve(Resolver resolver, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, Optional<ParameterContext> originalParameterContext) {
            return resolver.resolve(this, extensionContext, arguments, invocationIndex);
        }
    }

    private static class ExecutableParameterDeclaration
    extends ResolvableParameterDeclaration {
        private final java.lang.reflect.Parameter parameter;
        private final int index;
        private final int indexOffset;

        ExecutableParameterDeclaration(java.lang.reflect.Parameter parameter, int index, int indexOffset) {
            this.parameter = parameter;
            this.index = index;
            this.indexOffset = indexOffset;
        }

        @Override
        public java.lang.reflect.Parameter getAnnotatedElement() {
            return this.parameter;
        }

        @Override
        public Class<?> getParameterType() {
            return this.parameter.getType();
        }

        @Override
        public int getParameterIndex() {
            return this.index - this.indexOffset;
        }

        @Override
        public Optional<String> getParameterName() {
            return this.parameter.isNamePresent() ? Optional.of(this.parameter.getName()) : Optional.empty();
        }

        @Override
        public @Nullable Object resolve(Resolver resolver, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, Optional<ParameterContext> originalParameterContext) {
            ParameterContext parameterContext = originalParameterContext.filter(it -> it.getParameter().equals(this.parameter)).orElseGet(() -> this.toParameterContext(extensionContext, originalParameterContext));
            return resolver.resolve(parameterContext, this.getParameterIndex(), extensionContext, arguments, invocationIndex);
        }

        private ParameterContext toParameterContext(ExtensionContext extensionContext, Optional<ParameterContext> originalParameterContext) {
            Optional<Object> target = originalParameterContext.flatMap(ParameterContext::getTarget);
            if (target.isEmpty()) {
                target = extensionContext.getTestInstance();
            }
            return this.toParameterContext(target);
        }

        private ParameterContext toParameterContext(final Optional<Object> target) {
            return new ParameterContext(){
                final /* synthetic */ ExecutableParameterDeclaration this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public java.lang.reflect.Parameter getParameter() {
                    return this.this$0.parameter;
                }

                @Override
                public int getIndex() {
                    return this.this$0.index;
                }

                @Override
                public Optional<Object> getTarget() {
                    return target;
                }
            };
        }
    }

    private record DefaultParameterDeclarations(AnnotatedElement sourceElement, NavigableMap<Integer, ? extends ResolvableParameterDeclaration> declarationsByIndex) implements ParameterDeclarations
    {
        @Override
        public AnnotatedElement getSourceElement() {
            return this.sourceElement;
        }

        @Override
        public Optional<ParameterDeclaration> getFirst() {
            return this.declarationsByIndex.isEmpty() ? Optional.empty() : Optional.of((ParameterDeclaration)this.declarationsByIndex.firstEntry().getValue());
        }

        @Override
        public List<ParameterDeclaration> getAll() {
            return List.copyOf(this.declarationsByIndex.values());
        }

        @Override
        public Optional<ParameterDeclaration> get(int parameterIndex) {
            return Optional.ofNullable((ParameterDeclaration)this.declarationsByIndex.get(parameterIndex));
        }

        @Override
        public String getSourceElementDescription() {
            return DefaultParameterDeclarations.describe(this.sourceElement);
        }

        static String describe(AnnotatedElement sourceElement) {
            if (sourceElement instanceof Method) {
                Method method = (Method)sourceElement;
                return "method [%s]".formatted(method.toGenericString());
            }
            if (sourceElement instanceof Constructor) {
                Constructor constructor = (Constructor)sourceElement;
                return "constructor [%s]".formatted(constructor.toGenericString());
            }
            if (sourceElement instanceof Class) {
                Class clazz = (Class)sourceElement;
                return "class [%s]".formatted(clazz.getName());
            }
            return sourceElement.toString();
        }
    }

    private static abstract class ResolvableParameterDeclaration
    implements ParameterDeclaration {
        private ResolvableParameterDeclaration() {
        }

        boolean isAggregator() {
            return ArgumentsAccessor.class.isAssignableFrom(this.getParameterType()) || AnnotationSupport.isAnnotated(this.getAnnotatedElement(), AggregateWith.class);
        }

        protected abstract @Nullable Object resolve(Resolver var1, ExtensionContext var2, EvaluatedArgumentSet var3, int var4, Optional<ParameterContext> var5);
    }

    private static interface Resolver {
        public @Nullable Object resolve(ParameterContext var1, int var2, ExtensionContext var3, EvaluatedArgumentSet var4, int var5);

        public @Nullable Object resolve(FieldContext var1, ExtensionContext var2, EvaluatedArgumentSet var3, int var4);
    }

    private record Converter(ArgumentConverter argumentConverter) implements Resolver
    {
        private static Converter createDefault(ExtensionContext context) {
            return new Converter(new DefaultArgumentConverter(context));
        }

        @Override
        public @Nullable Object resolve(ParameterContext parameterContext, int parameterIndex, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex) {
            Object argument = arguments.getConsumedPayload(parameterIndex);
            try {
                return this.argumentConverter.convert(argument, parameterContext);
            }
            catch (Exception ex) {
                throw ResolverFacade.parameterResolutionException("Error converting parameter", ex, parameterContext.getIndex());
            }
        }

        @Override
        public @Nullable Object resolve(FieldContext fieldContext, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex) {
            Object argument = arguments.getConsumedPayload(fieldContext.getParameterIndex());
            try {
                return this.argumentConverter.convert(argument, fieldContext);
            }
            catch (Exception ex) {
                throw ResolverFacade.parameterResolutionException("Error converting parameter", ex, fieldContext.getParameterIndex());
            }
        }
    }

    private record Aggregator(ArgumentsAggregator argumentsAggregator) implements Resolver
    {
        private static final Aggregator DEFAULT = new Aggregator(new SimpleArgumentsAggregator(){

            @Override
            protected Object aggregateArguments(ArgumentsAccessor accessor, Class<?> targetType, AnnotatedElementContext context, int parameterIndex) throws ArgumentsAggregationException {
                return accessor;
            }
        });

        @Override
        public @Nullable Object resolve(ParameterContext parameterContext, int parameterIndex, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex) {
            ArgumentsAccessor accessor = Objects.requireNonNull(ParameterInfo.get(extensionContext)).getArguments();
            try {
                return this.argumentsAggregator.aggregateArguments(accessor, parameterContext);
            }
            catch (Exception ex) {
                throw ResolverFacade.parameterResolutionException("Error aggregating arguments for parameter", ex, parameterContext.getIndex());
            }
        }

        @Override
        public @Nullable Object resolve(FieldContext fieldContext, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex) {
            ArgumentsAccessor accessor = Objects.requireNonNull(ParameterInfo.get(extensionContext)).getArguments();
            try {
                return this.argumentsAggregator.aggregateArguments(accessor, fieldContext);
            }
            catch (Exception ex) {
                throw ResolverFacade.parameterResolutionException("Error aggregating arguments for parameter", ex, fieldContext.getParameterIndex());
            }
        }
    }

    private record DefaultArgumentSetLifecycleMethodParameterResolver(ResolverFacade originalResolverFacade, ResolverFacade lifecycleMethodResolverFacade, Map<ParameterDeclaration, ResolvableParameterDeclaration> parameterDeclarationMapping) implements ArgumentSetLifecycleMethod.ParameterResolver
    {
        @Override
        public boolean supports(ParameterContext parameterContext) {
            return this.lifecycleMethodResolverFacade.findDeclaration(parameterContext.getIndex()).filter(it -> this.parameterDeclarationMapping.containsKey(it) || it.isAggregator()).isPresent();
        }

        @Override
        public @Nullable Object resolve(ParameterContext parameterContext, ExtensionContext extensionContext, EvaluatedArgumentSet arguments, int invocationIndex, ResolutionCache resolutionCache) {
            ResolvableParameterDeclaration actualDeclaration = this.lifecycleMethodResolverFacade.findDeclaration(parameterContext.getIndex()).orElseThrow(() -> new ParameterResolutionException("Parameter index out of bounds: " + parameterContext.getIndex()));
            ResolvableParameterDeclaration originalDeclaration = this.parameterDeclarationMapping.get(actualDeclaration);
            if (originalDeclaration == null) {
                return this.lifecycleMethodResolverFacade.resolve(actualDeclaration, extensionContext, arguments, invocationIndex, Optional.of(parameterContext));
            }
            return resolutionCache.resolve(originalDeclaration, () -> this.originalResolverFacade.resolve(originalDeclaration, extensionContext, arguments, invocationIndex, Optional.of(parameterContext)));
        }
    }
}

