/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutDurationParser;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

class TimeoutConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutConfiguration.class);
    private final TimeoutDurationParser parser = new TimeoutDurationParser();
    private final Map<String, Optional<TimeoutDuration>> cache = new ConcurrentHashMap<String, Optional<TimeoutDuration>>();
    private final AtomicReference<Optional<Timeout.ThreadMode>> threadMode = new AtomicReference();
    private final ExtensionContext extensionContext;

    TimeoutConfiguration(ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    Optional<TimeoutDuration> getDefaultTestMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.test.method.default", this::getDefaultTestableMethodTimeout);
    }

    Optional<TimeoutDuration> getDefaultTestTemplateMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.testtemplate.method.default", this::getDefaultTestableMethodTimeout);
    }

    Optional<TimeoutDuration> getDefaultTestFactoryMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.testfactory.method.default", this::getDefaultTestableMethodTimeout);
    }

    Optional<TimeoutDuration> getDefaultBeforeAllMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.beforeall.method.default", this::getDefaultLifecycleMethodTimeout);
    }

    Optional<TimeoutDuration> getDefaultBeforeEachMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.beforeeach.method.default", this::getDefaultLifecycleMethodTimeout);
    }

    Optional<TimeoutDuration> getDefaultAfterEachMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.aftereach.method.default", this::getDefaultLifecycleMethodTimeout);
    }

    Optional<TimeoutDuration> getDefaultAfterAllMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.afterall.method.default", this::getDefaultLifecycleMethodTimeout);
    }

    private Optional<TimeoutDuration> getDefaultTestableMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.testable.method.default", this::getDefaultTimeout);
    }

    private Optional<TimeoutDuration> getDefaultLifecycleMethodTimeout() {
        return this.parseOrDefault("junit.jupiter.execution.timeout.lifecycle.method.default", this::getDefaultTimeout);
    }

    private Optional<TimeoutDuration> getDefaultTimeout() {
        return this.parseTimeoutDuration("junit.jupiter.execution.timeout.default");
    }

    private Optional<TimeoutDuration> parseOrDefault(String propertyName, Supplier<Optional<TimeoutDuration>> defaultSupplier) {
        Optional<TimeoutDuration> timeoutConfiguration = this.parseTimeoutDuration(propertyName);
        return timeoutConfiguration.isPresent() ? timeoutConfiguration : defaultSupplier.get();
    }

    private Optional<TimeoutDuration> parseTimeoutDuration(String propertyName) {
        return this.cache.computeIfAbsent(propertyName, key -> this.extensionContext.getConfigurationParameter((String)key).map(value -> {
            try {
                return this.parser.parse((CharSequence)value);
            }
            catch (Exception e) {
                logger.warn(e, () -> "Ignored invalid timeout '%s' set via the '%s' configuration parameter.".formatted(value, key));
                return null;
            }
        }));
    }

    Optional<Timeout.ThreadMode> getDefaultTimeoutThreadMode() {
        if (this.threadMode.get() != null) {
            return this.threadMode.get();
        }
        Optional<Timeout.ThreadMode> configuredThreadMode = this.parseTimeoutThreadModeConfiguration();
        this.threadMode.set(configuredThreadMode);
        return configuredThreadMode;
    }

    private Optional<Timeout.ThreadMode> parseTimeoutThreadModeConfiguration() {
        return this.extensionContext.getConfigurationParameter("junit.jupiter.execution.timeout.thread.mode.default").map(value -> {
            try {
                Timeout.ThreadMode threadMode = Timeout.ThreadMode.valueOf(value.toUpperCase());
                if (threadMode == Timeout.ThreadMode.INFERRED) {
                    logger.warn(() -> "Invalid timeout thread mode '%s', only %s and %s can be used as configuration parameter for %s.".formatted(new Object[]{value, Timeout.ThreadMode.SAME_THREAD, Timeout.ThreadMode.SEPARATE_THREAD, "junit.jupiter.execution.timeout.thread.mode.default"}));
                    return null;
                }
                return threadMode;
            }
            catch (Exception e) {
                logger.warn(e, () -> "Invalid timeout thread mode '%s' set via the '%s' configuration parameter.".formatted(value, "junit.jupiter.execution.timeout.thread.mode.default"));
                return null;
            }
        });
    }
}

