/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.AnnotatedElementContext;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.io.TempDirFactory;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;

class TempDirectory
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(TempDirectory.class);
    static final String FILE_OPERATIONS_KEY = "file.operations";
    private static final String KEY = "temp.dir";
    private static final String FAILURE_TRACKER = "failure.tracker";
    private static final String CHILD_FAILED = "child.failed";
    private final JupiterConfiguration configuration;

    public TempDirectory(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    @Override
    public void beforeAll(ExtensionContext context) {
        TempDirectory.installFailureTracker(context);
        this.injectStaticFields(context, context.getRequiredTestClass());
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        TempDirectory.installFailureTracker(context);
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectInstanceFields(context, instance));
    }

    private static void installFailureTracker(ExtensionContext context) {
        context.getParent().filter(parentContext -> !context.getRoot().equals(parentContext)).ifPresent(parentContext -> TempDirectory.installFailureTracker(context, parentContext));
    }

    private static void installFailureTracker(ExtensionContext context, ExtensionContext parentContext) {
        context.getStore(NAMESPACE).put(FAILURE_TRACKER, new FailureTracker(context, parentContext));
    }

    private void injectStaticFields(ExtensionContext context, Class<?> testClass) {
        this.injectFields(context, null, testClass, ModifierSupport::isStatic);
    }

    private void injectInstanceFields(ExtensionContext context, Object instance) {
        if (!ReflectionUtils.isRecordObject(instance)) {
            this.injectFields(context, instance, instance.getClass(), ModifierSupport::isNotStatic);
        }
    }

    private void injectFields(ExtensionContext context, @Nullable Object testInstance, Class<?> testClass, Predicate<Field> predicate) {
        AnnotationSupport.findAnnotatedFields(testClass, TempDir.class, predicate).forEach(field -> {
            TempDirectory.assertNonFinalField(field);
            TempDirectory.assertSupportedType("field", field.getType());
            try {
                CleanupMode cleanupMode = this.determineCleanupModeForField((Field)field);
                TempDirFactory factory = this.determineTempDirFactoryForField((Field)field);
                ReflectionSupport.makeAccessible(field).set(testInstance, TempDirectory.getPathOrFile(field.getType(), new FieldContext((Field)field), factory, cleanupMode, context));
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException(t);
            }
        });
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.isAnnotated(TempDir.class);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        TempDirectory.assertSupportedType("parameter", parameterType);
        CleanupMode cleanupMode = this.determineCleanupModeForParameter(parameterContext);
        TempDirFactory factory = this.determineTempDirFactoryForParameter(parameterContext);
        return TempDirectory.getPathOrFile(parameterType, parameterContext, factory, cleanupMode, extensionContext);
    }

    private CleanupMode determineCleanupModeForField(Field field) {
        TempDir tempDir = AnnotationSupport.findAnnotation(field, TempDir.class).orElseThrow(() -> new JUnitException("Field " + String.valueOf(field) + " must be annotated with @TempDir"));
        return this.determineCleanupMode(tempDir);
    }

    private CleanupMode determineCleanupModeForParameter(ParameterContext parameterContext) {
        TempDir tempDir = parameterContext.findAnnotation(TempDir.class).orElseThrow(() -> new JUnitException("Parameter " + String.valueOf(parameterContext.getParameter()) + " must be annotated with @TempDir"));
        return this.determineCleanupMode(tempDir);
    }

    private CleanupMode determineCleanupMode(TempDir tempDir) {
        CleanupMode cleanupMode = tempDir.cleanup();
        return cleanupMode == CleanupMode.DEFAULT ? this.configuration.getDefaultTempDirCleanupMode() : cleanupMode;
    }

    private TempDirFactory determineTempDirFactoryForField(Field field) {
        TempDir tempDir = AnnotationSupport.findAnnotation(field, TempDir.class).orElseThrow(() -> new JUnitException("Field " + String.valueOf(field) + " must be annotated with @TempDir"));
        return this.determineTempDirFactory(tempDir);
    }

    private TempDirFactory determineTempDirFactoryForParameter(ParameterContext parameterContext) {
        TempDir tempDir = parameterContext.findAnnotation(TempDir.class).orElseThrow(() -> new JUnitException("Parameter " + String.valueOf(parameterContext.getParameter()) + " must be annotated with @TempDir"));
        return this.determineTempDirFactory(tempDir);
    }

    private TempDirFactory determineTempDirFactory(TempDir tempDir) {
        Class<? extends TempDirFactory> factory = tempDir.factory();
        return factory == TempDirFactory.class ? this.configuration.getDefaultTempDirFactorySupplier().get() : ReflectionSupport.newInstance(factory, new Object[0]);
    }

    private static void assertNonFinalField(Field field) {
        if (ModifierSupport.isFinal(field)) {
            throw new ExtensionConfigurationException("@TempDir field [" + String.valueOf(field) + "] must not be declared as final.");
        }
    }

    private static void assertSupportedType(String target, Class<?> type) {
        if (type != Path.class && type != File.class) {
            throw new ExtensionConfigurationException("Can only resolve @TempDir " + target + " of type " + Path.class.getName() + " or " + File.class.getName() + " but was: " + type.getName());
        }
    }

    private static Object getPathOrFile(Class<?> elementType, AnnotatedElementContext elementContext, TempDirFactory factory, CleanupMode cleanupMode, ExtensionContext extensionContext) {
        Path path = Objects.requireNonNull(extensionContext.getStore(NAMESPACE.append(elementContext)).getOrComputeIfAbsent(KEY, __ -> TempDirectory.createTempDir(factory, cleanupMode, elementType, elementContext, extensionContext), CloseablePath.class)).get();
        return elementType == Path.class ? path : path.toFile();
    }

    static CloseablePath createTempDir(TempDirFactory factory, CleanupMode cleanupMode, Class<?> elementType, AnnotatedElementContext elementContext, ExtensionContext extensionContext) {
        try {
            return new CloseablePath(factory, cleanupMode, elementType, elementContext, extensionContext);
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create default temp directory", ex);
        }
    }

    private static boolean selfOrChildFailed(ExtensionContext context) {
        return context.getExecutionException().isPresent() || TempDirectory.getContextSpecificStore(context).getOrDefault(CHILD_FAILED, Boolean.class, false) != false;
    }

    private static ExtensionContext.Store getContextSpecificStore(ExtensionContext context) {
        return context.getStore(NAMESPACE.append(context));
    }

    private record FailureTracker(ExtensionContext context, ExtensionContext parentContext) implements ExtensionContext.Store.CloseableResource,
    AutoCloseable
    {
        @Override
        public void close() {
            if (TempDirectory.selfOrChildFailed(this.context)) {
                TempDirectory.getContextSpecificStore(this.parentContext).put(TempDirectory.CHILD_FAILED, true);
            }
        }
    }

    static class CloseablePath
    implements ExtensionContext.Store.CloseableResource,
    AutoCloseable {
        private static final Logger LOGGER = LoggerFactory.getLogger(CloseablePath.class);
        private final Path dir;
        private final TempDirFactory factory;
        private final CleanupMode cleanupMode;
        private final AnnotatedElement annotatedElement;
        private final ExtensionContext extensionContext;

        private CloseablePath(TempDirFactory factory, CleanupMode cleanupMode, Class<?> elementType, AnnotatedElementContext elementContext, ExtensionContext extensionContext) throws Exception {
            this.dir = factory.createTempDirectory(elementContext, extensionContext);
            this.factory = factory;
            this.cleanupMode = cleanupMode;
            this.annotatedElement = elementContext.getAnnotatedElement();
            this.extensionContext = extensionContext;
            if (this.dir == null || !Files.isDirectory(this.dir, new LinkOption[0])) {
                this.close();
                throw new PreconditionViolationException("temp directory must be a directory");
            }
            if (elementType == File.class && !this.dir.getFileSystem().equals(FileSystems.getDefault())) {
                this.close();
                throw new PreconditionViolationException("temp directory with non-default file system cannot be injected into " + File.class.getName() + " target");
            }
        }

        Path get() {
            return this.dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.cleanupMode == CleanupMode.NEVER || this.cleanupMode == CleanupMode.ON_SUCCESS && TempDirectory.selfOrChildFailed(this.extensionContext)) {
                    LOGGER.info(() -> "Skipping cleanup of temp dir %s for %s due to CleanupMode.%s.".formatted(this.dir, CloseablePath.descriptionFor(this.annotatedElement), this.cleanupMode.name()));
                    return;
                }
                FileOperations fileOperations = this.extensionContext.getStore(NAMESPACE).getOrDefault(TempDirectory.FILE_OPERATIONS_KEY, FileOperations.class, FileOperations.DEFAULT);
                FileOperations loggingFileOperations = file -> {
                    LOGGER.trace(() -> "Attempting to delete " + String.valueOf(file));
                    try {
                        fileOperations.delete(file);
                        LOGGER.trace(() -> "Successfully deleted " + String.valueOf(file));
                    }
                    catch (IOException e) {
                        LOGGER.trace(e, () -> "Failed to delete " + String.valueOf(file));
                        throw e;
                    }
                };
                LOGGER.trace(() -> "Cleaning up temp dir " + String.valueOf(this.dir));
                SortedMap<Path, IOException> failures = this.deleteAllFilesAndDirectories(loggingFileOperations);
                if (!failures.isEmpty()) {
                    throw this.createIOExceptionWithAttachedFailures(failures);
                }
            }
            finally {
                this.factory.close();
            }
        }

        private static String descriptionFor(AnnotatedElement annotatedElement) {
            if (annotatedElement instanceof Field) {
                Field field = (Field)annotatedElement;
                return "field " + field.getDeclaringClass().getSimpleName() + "." + field.getName();
            }
            if (annotatedElement instanceof Parameter) {
                Parameter parameter = (Parameter)annotatedElement;
                Executable executable = parameter.getDeclaringExecutable();
                return "parameter '" + parameter.getName() + "' in " + CloseablePath.descriptionFor(executable);
            }
            throw new IllegalStateException("Unsupported AnnotatedElement type for @TempDir: " + String.valueOf(annotatedElement));
        }

        private static String descriptionFor(Executable executable) {
            boolean isConstructor = executable instanceof Constructor;
            String type = isConstructor ? "constructor" : "method";
            String name = isConstructor ? executable.getDeclaringClass().getSimpleName() : executable.getName();
            return "%s %s(%s)".formatted(type, name, ClassUtils.nullSafeToString(Class::getSimpleName, executable.getParameterTypes()));
        }

        private SortedMap<Path, IOException> deleteAllFilesAndDirectories(final FileOperations fileOperations) throws IOException {
            final Path rootDir = this.dir;
            if (rootDir == null || Files.notExists(rootDir, new LinkOption[0])) {
                return Collections.emptySortedMap();
            }
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            final HashSet retriedPaths = new HashSet();
            final Path rootRealPath = rootDir.toRealPath(new LinkOption[0]);
            CloseablePath.tryToResetPermissions(rootDir);
            Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                final /* synthetic */ CloseablePath this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    LOGGER.trace(() -> "preVisitDirectory: " + String.valueOf(dir));
                    if (this.isLinkWithTargetOutsideTempDir(dir)) {
                        this.warnAboutLinkWithTargetOutsideTempDir("link", dir);
                        this.delete(dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!dir.equals(rootDir)) {
                        CloseablePath.tryToResetPermissions(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOGGER.trace(exc, () -> "visitFileFailed: " + String.valueOf(file));
                    if (exc instanceof NoSuchFileException && !Files.exists(file, LinkOption.NOFOLLOW_LINKS)) {
                        return FileVisitResult.CONTINUE;
                    }
                    this.resetPermissionsAndTryToDeleteAgain(file, exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    LOGGER.trace(() -> "visitFile: " + String.valueOf(file));
                    if (Files.isSymbolicLink(file) && this.isLinkWithTargetOutsideTempDir(file)) {
                        this.warnAboutLinkWithTargetOutsideTempDir("symbolic link", file);
                    }
                    this.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    LOGGER.trace(exc, () -> "postVisitDirectory: " + String.valueOf(dir));
                    this.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                private boolean isLinkWithTargetOutsideTempDir(Path path) {
                    try {
                        return !path.toRealPath(new LinkOption[0]).startsWith(rootRealPath);
                    }
                    catch (IOException e) {
                        LOGGER.trace(e, () -> "Failed to determine real path for " + String.valueOf(path) + "; assuming it is not a link");
                        return false;
                    }
                }

                private void warnAboutLinkWithTargetOutsideTempDir(String linkType, Path file) throws IOException {
                    Path realPath = file.toRealPath(new LinkOption[0]);
                    LOGGER.warn(() -> String.format("Deleting %s from location inside of temp dir (%s) to location outside of temp dir (%s) but not the target file/directory", linkType, file, realPath));
                }

                private void delete(Path path) {
                    try {
                        fileOperations.delete(path);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                    catch (DirectoryNotEmptyException exception) {
                        failures.put(path, exception);
                    }
                    catch (IOException exception) {
                        this.resetPermissionsAndTryToDeleteAgain(path, exception);
                    }
                }

                private void resetPermissionsAndTryToDeleteAgain(Path path, IOException exception) {
                    block5: {
                        boolean notYetRetried = retriedPaths.add(path);
                        if (notYetRetried) {
                            try {
                                CloseablePath.tryToResetPermissions(path);
                                if (Files.isDirectory(path, new LinkOption[0])) {
                                    Files.walkFileTree(path, this);
                                    break block5;
                                }
                                fileOperations.delete(path);
                            }
                            catch (Exception suppressed) {
                                exception.addSuppressed(suppressed);
                                failures.put(path, exception);
                            }
                        } else {
                            failures.put(path, exception);
                        }
                    }
                }
            });
            return failures;
        }

        private static void tryToResetPermissions(Path path) {
            DosFileAttributeView dos;
            File file;
            try {
                file = path.toFile();
            }
            catch (UnsupportedOperationException ignore) {
                return;
            }
            file.setReadable(true);
            file.setWritable(true);
            if (Files.isDirectory(path, new LinkOption[0])) {
                file.setExecutable(true);
            }
            if ((dos = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0])) != null) {
                try {
                    dos.setReadOnly(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private IOException createIOExceptionWithAttachedFailures(SortedMap<Path, IOException> failures) {
            Path emptyPath = Path.of("", new String[0]);
            String joinedPaths = failures.keySet().stream().map(this::tryToDeleteOnExit).map(this::relativizeSafely).map(path -> emptyPath.equals(path) ? "<root>" : path.toString()).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to delete temp directory " + String.valueOf(this.dir.toAbsolutePath()) + ". The following paths could not be deleted (see suppressed exceptions for details): " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            return exception;
        }

        private Path tryToDeleteOnExit(Path path) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return path;
        }

        private Path relativizeSafely(Path path) {
            try {
                return this.dir.relativize(path);
            }
            catch (IllegalArgumentException e) {
                return path;
            }
        }
    }

    private record FieldContext(Field field) implements AnnotatedElementContext
    {
        private FieldContext(Field field) {
            this.field = Preconditions.notNull(field, "field must not be null");
        }

        @Override
        public AnnotatedElement getAnnotatedElement() {
            return this.field;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this).append("field", this.field).toString();
        }
    }

    static interface FileOperations {
        public static final FileOperations DEFAULT = Files::delete;

        public void delete(Path var1) throws IOException;
    }
}

