/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import org.apiguardian.api.API;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.descriptor.Validatable;
import org.junit.jupiter.engine.discovery.ClassOrderingVisitor;
import org.junit.jupiter.engine.discovery.ClassSelectorResolver;
import org.junit.jupiter.engine.discovery.MethodOrderingVisitor;
import org.junit.jupiter.engine.discovery.MethodSelectorResolver;
import org.junit.jupiter.engine.discovery.predicates.TestClassPredicates;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;

@API(status=API.Status.INTERNAL, since="5.0")
public class DiscoverySelectorResolver {
    private static final EngineDiscoveryRequestResolver<JupiterEngineDescriptor> resolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolverWithContext(ctx -> new TestClassPredicates((DiscoveryIssueReporter)ctx.getIssueReporter()).looksLikeNestedOrStandaloneTestClass).addSelectorResolver(ctx -> new ClassSelectorResolver(ctx.getClassNameFilter(), DiscoverySelectorResolver.getConfiguration(ctx), ctx.getIssueReporter())).addSelectorResolver(ctx -> new MethodSelectorResolver(DiscoverySelectorResolver.getConfiguration(ctx), ctx.getIssueReporter())).addTestDescriptorVisitor(ctx -> TestDescriptor.Visitor.composite(new ClassOrderingVisitor(DiscoverySelectorResolver.getConfiguration(ctx), ctx.getIssueReporter()), new MethodOrderingVisitor(DiscoverySelectorResolver.getConfiguration(ctx), ctx.getIssueReporter()), descriptor -> {
        if (descriptor instanceof Validatable) {
            Validatable validatable = (Validatable)((Object)descriptor);
            validatable.validate(ctx.getIssueReporter());
        }
    })).build();

    private static JupiterConfiguration getConfiguration(EngineDiscoveryRequestResolver.InitializationContext<JupiterEngineDescriptor> context) {
        return context.getEngineDescriptor().getConfiguration();
    }

    public static void resolveSelectors(EngineDiscoveryRequest request, JupiterEngineDescriptor engineDescriptor, DiscoveryIssueReporter issueReporter) {
        resolver.resolve(request, engineDescriptor, issueReporter);
    }
}

