/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.TemplateExecutor;
import org.junit.jupiter.engine.descriptor.TestTemplateExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestTemplateTestDescriptor
extends MethodBasedTestDescriptor
implements Filterable {
    public static final String SEGMENT_TYPE = "test-template";
    private final DynamicDescendantFilter dynamicDescendantFilter;

    public TestTemplateTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod, Supplier<List<Class<?>>> enclosingInstanceTypes, JupiterConfiguration configuration) {
        super(uniqueId, testClass, templateMethod, enclosingInstanceTypes, configuration);
        this.dynamicDescendantFilter = new DynamicDescendantFilter();
    }

    private TestTemplateTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method templateMethod, JupiterConfiguration configuration, DynamicDescendantFilter dynamicDescendantFilter) {
        super(uniqueId, displayName, testClass, templateMethod, configuration);
        this.dynamicDescendantFilter = dynamicDescendantFilter;
    }

    @Override
    protected TestTemplateTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new TestTemplateTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.getDisplayName(), this.getTestClass(), this.getTestMethod(), this.configuration, this.dynamicDescendantFilter.copy(uniqueIdTransformer));
    }

    @Override
    public DynamicDescendantFilter getDynamicDescendantFilter() {
        return this.dynamicDescendantFilter;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public boolean mayRegisterTests() {
        return true;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.getTestMethod());
        TestInstances testInstances = context.getExtensionContext().getTestInstances().orElse(null);
        TestTemplateExtensionContext extensionContext = new TestTemplateExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfiguration(), registry, context.getLauncherStoreFacade(), testInstances);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).build();
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        new TestTemplateExecutor().execute(context, dynamicTestExecutor);
        return context;
    }

    private class TestTemplateExecutor
    extends TemplateExecutor<TestTemplateInvocationContextProvider, TestTemplateInvocationContext> {
        TestTemplateExecutor() {
            super(TestTemplateTestDescriptor.this, TestTemplateInvocationContextProvider.class);
        }

        @Override
        boolean supports(TestTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
            return provider.supportsTestTemplate(extensionContext);
        }

        @Override
        protected String getNoRegisteredProviderErrorMessage() {
            return "You must register at least one %s that supports @%s method [%s]".formatted(TestTemplateInvocationContextProvider.class.getSimpleName(), TestTemplate.class.getSimpleName(), TestTemplateTestDescriptor.this.getTestMethod());
        }

        @Override
        Stream<? extends TestTemplateInvocationContext> provideContexts(TestTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
            return provider.provideTestTemplateInvocationContexts(extensionContext);
        }

        @Override
        boolean mayReturnZeroContexts(TestTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
            return provider.mayReturnZeroTestTemplateInvocationContexts(extensionContext);
        }

        @Override
        protected String getZeroContextsProvidedErrorMessage(TestTemplateInvocationContextProvider provider) {
            return String.format("Provider [%s] did not provide any invocation contexts, but was expected to do so. You may override mayReturnZeroTestTemplateInvocationContexts() to allow this.", provider.getClass().getSimpleName());
        }

        @Override
        UniqueId createInvocationUniqueId(UniqueId parentUniqueId, int index) {
            return parentUniqueId.append("test-template-invocation", "#" + index);
        }

        @Override
        TestDescriptor createInvocationTestDescriptor(UniqueId uniqueId, TestTemplateInvocationContext invocationContext, int index) {
            return new TestTemplateInvocationTestDescriptor(uniqueId, TestTemplateTestDescriptor.this.getTestClass(), TestTemplateTestDescriptor.this.getTestMethod(), invocationContext, index, TestTemplateTestDescriptor.this.configuration);
        }
    }
}

