/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.net.URI;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.MethodSource;

class MethodSourceSupport {
    static final String METHOD_SCHEME = "method";

    MethodSourceSupport() {
    }

    static MethodSource from(URI uri) {
        Preconditions.notNull(uri, "URI must not be null");
        Preconditions.condition(METHOD_SCHEME.equals(uri.getScheme()), () -> "URI [" + String.valueOf(uri) + "] must have [method] scheme");
        String schemeSpecificPart = Preconditions.notNull(uri.getSchemeSpecificPart(), () -> "Invalid method URI (scheme-specific part must not be null). Please consult the Javadoc of " + DiscoverySelectors.class.getName() + "#selectMethod(String) for details on the supported formats.");
        String fragment = Preconditions.notNull(uri.getFragment(), () -> "Invalid method URI (fragment must not be null). Please consult the Javadoc of " + DiscoverySelectors.class.getName() + "#selectMethod(String) for details on the supported formats.");
        String fullyQualifiedMethodName = schemeSpecificPart + "#" + fragment;
        String[] methodSpec = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        return MethodSource.from(methodSpec[0], methodSpec[1], methodSpec[2]);
    }
}

