/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.jupiter.api.parallel.ResourceLockTarget;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.descriptor.ExclusiveResourceCollector;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.ResourceLockAware;
import org.junit.jupiter.engine.descriptor.TestClassAware;
import org.junit.jupiter.engine.descriptor.Validatable;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public abstract class MethodBasedTestDescriptor
extends JupiterTestDescriptor
implements ResourceLockAware,
TestClassAware,
Validatable {
    private static final Logger logger = LoggerFactory.getLogger(MethodBasedTestDescriptor.class);
    private final MethodInfo methodInfo;

    MethodBasedTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod, Supplier<List<Class<?>>> enclosingInstanceTypes, JupiterConfiguration configuration) {
        this(uniqueId, DisplayNameUtils.determineDisplayNameForMethod(enclosingInstanceTypes, testClass, testMethod, configuration), testClass, testMethod, configuration);
    }

    MethodBasedTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        super(uniqueId, displayName, MethodSource.from(testClass, testMethod), configuration);
        this.methodInfo = new MethodInfo(testClass, testMethod);
    }

    public final Method getTestMethod() {
        return this.methodInfo.testMethod;
    }

    @Override
    public final Set<TestTag> getTags() {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(this.methodInfo.tags);
        this.getParent().ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    @Override
    public String getLegacyReportingName() {
        return "%s(%s)".formatted(this.getTestMethod().getName(), ClassUtils.nullSafeToString(Class::getSimpleName, this.getTestMethod().getParameterTypes()));
    }

    @Override
    public final Class<?> getTestClass() {
        return this.methodInfo.testClass;
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return this.getParent().filter(TestClassAware.class::isInstance).map(TestClassAware.class::cast).map(TestClassAware::getEnclosingTestClasses).orElseGet(Collections::emptyList);
    }

    @Override
    public void validate(DiscoveryIssueReporter reporter) {
        Validatable.reportAndClear(this.methodInfo.discoveryIssues, reporter);
        DisplayNameUtils.validateAnnotation(this.getTestMethod(), () -> "method '%s'".formatted(this.getTestMethod().toGenericString()), () -> MethodSource.from(this.getTestMethod()), reporter);
    }

    @Override
    public ExclusiveResourceCollector getExclusiveResourceCollector() {
        ExclusiveResourceCollector collector = ExclusiveResourceCollector.from(this.getTestMethod());
        if (collector.getStaticResourcesFor(ResourceLockTarget.CHILDREN).findAny().isPresent()) {
            String message = "'ResourceLockTarget.CHILDREN' is not supported for methods. Invalid method: " + String.valueOf(this.getTestMethod());
            throw new JUnitException(message);
        }
        return collector;
    }

    @Override
    public Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> getResourceLocksProviderEvaluator() {
        return ResourceLockAware.enclosingInstanceTypesDependentResourceLocksProviderEvaluator(this::getEnclosingTestClasses, (provider, enclosingInstanceTypes) -> provider.provideForMethod((List<Class<?>>)enclosingInstanceTypes, this.getTestClass(), this.getTestMethod()));
    }

    @Override
    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.getExecutionModeFromAnnotation(this.getTestMethod());
    }

    @Override
    public void nodeSkipped(JupiterEngineExecutionContext context, TestDescriptor descriptor, Node.SkipResult result) {
        this.invokeTestWatchers(context, false, watcher -> watcher.testDisabled(context.getExtensionContext(), result.getReason()));
    }

    protected void invokeTestWatchers(JupiterEngineExecutionContext context, boolean reverseOrder, Consumer<TestWatcher> callback) {
        List<TestWatcher> watchers = context.getExtensionRegistry().getExtensions(TestWatcher.class);
        Consumer<TestWatcher> action = watcher -> {
            try {
                callback.accept((TestWatcher)watcher);
            }
            catch (Throwable throwable) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
                ExtensionContext extensionContext = context.getExtensionContext();
                logger.warn(throwable, () -> "Failed to invoke TestWatcher [%s] for method [%s] with display name [%s]".formatted(watcher.getClass().getName(), ReflectionUtils.getFullyQualifiedMethodName(extensionContext.getRequiredTestClass(), extensionContext.getRequiredTestMethod()), this.getDisplayName()));
            }
        };
        if (reverseOrder) {
            CollectionUtils.forEachInReverseOrder(watchers, action);
        } else {
            watchers.forEach(action);
        }
    }

    private static class MethodInfo {
        private final List<DiscoveryIssue> discoveryIssues = new ArrayList<DiscoveryIssue>();
        private final Class<?> testClass;
        private final Method testMethod;
        private final Set<TestTag> tags;

        MethodInfo(Class<?> testClass, Method testMethod) {
            this.testClass = Preconditions.notNull(testClass, "Class must not be null");
            this.testMethod = testMethod;
            this.tags = JupiterTestDescriptor.getTags(testMethod, () -> "method '%s'".formatted(testMethod.toGenericString()), () -> MethodSource.from(testMethod.getDeclaringClass(), testMethod), this.discoveryIssues::add);
        }
    }
}

