/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.descriptor.ResourceLockAware;
import org.junit.jupiter.engine.execution.ConditionEvaluator;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public abstract class JupiterTestDescriptor
extends AbstractTestDescriptor
implements Node<JupiterEngineExecutionContext> {
    private static final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    final JupiterConfiguration configuration;

    JupiterTestDescriptor(UniqueId uniqueId, AnnotatedElement element, Supplier<String> displayNameSupplier, @Nullable TestSource source, JupiterConfiguration configuration) {
        this(uniqueId, DisplayNameUtils.determineDisplayName(element, displayNameSupplier), source, configuration);
    }

    JupiterTestDescriptor(UniqueId uniqueId, String displayName, @Nullable TestSource source, JupiterConfiguration configuration) {
        super(uniqueId, displayName, source);
        this.configuration = configuration;
    }

    static Set<TestTag> getTags(AnnotatedElement element, Supplier<String> elementDescription, Supplier<TestSource> sourceProvider, Consumer<DiscoveryIssue> issueCollector) {
        AtomicReference<@Nullable V> source = new AtomicReference();
        return AnnotationSupport.findRepeatableAnnotations(element, Tag.class).stream().map(Tag::value).filter(tag -> {
            boolean isValid = TestTag.isValid(tag);
            if (!isValid) {
                String message = "Invalid tag syntax in @Tag(\"%s\") declaration on %s. Tag will be ignored.".formatted(tag, elementDescription.get());
                if (source.get() == null) {
                    source.set((TestSource)sourceProvider.get());
                }
                issueCollector.accept(DiscoveryIssue.builder(DiscoveryIssue.Severity.WARNING, message).source((TestSource)source.get()).build());
            }
            return isValid;
        }).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    <E extends Extension> void invokeExecutionExceptionHandlers(Class<E> handlerType, ExtensionRegistry registry, Throwable throwable, ExceptionHandlerInvoker<E> handlerInvoker) {
        List<E> extensions = registry.getExtensions(handlerType);
        Collections.reverse(extensions);
        this.invokeExecutionExceptionHandlers(extensions, throwable, handlerInvoker);
    }

    private <E extends Extension> void invokeExecutionExceptionHandlers(List<E> exceptionHandlers, Throwable throwable, ExceptionHandlerInvoker<E> handlerInvoker) {
        if (exceptionHandlers.isEmpty()) {
            throw ExceptionUtils.throwAsUncheckedException(throwable);
        }
        try {
            handlerInvoker.invoke((Extension)exceptionHandlers.remove(0), throwable);
        }
        catch (Throwable handledThrowable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(handledThrowable);
            this.invokeExecutionExceptionHandlers(exceptionHandlers, handledThrowable, handlerInvoker);
        }
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        TestDescriptor testDescriptor;
        Optional<Node.ExecutionMode> executionMode = this.getExplicitExecutionMode();
        if (executionMode.isPresent()) {
            return executionMode.get();
        }
        Optional<TestDescriptor> parent = this.getParent();
        while (parent.isPresent() && (testDescriptor = parent.get()) instanceof JupiterTestDescriptor) {
            JupiterTestDescriptor jupiterParent = (JupiterTestDescriptor)testDescriptor;
            executionMode = jupiterParent.getExplicitExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            executionMode = jupiterParent.getDefaultChildExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            parent = jupiterParent.getParent();
        }
        return JupiterTestDescriptor.toExecutionMode(this.configuration.getDefaultExecutionMode());
    }

    Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return Optional.empty();
    }

    Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return Optional.empty();
    }

    Optional<Node.ExecutionMode> getExecutionModeFromAnnotation(AnnotatedElement element) {
        return AnnotationSupport.findAnnotation(element, Execution.class).map(Execution::value).map(JupiterTestDescriptor::toExecutionMode);
    }

    public static Node.ExecutionMode toExecutionMode(ExecutionMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ExecutionMode.CONCURRENT -> Node.ExecutionMode.CONCURRENT;
            case ExecutionMode.SAME_THREAD -> Node.ExecutionMode.SAME_THREAD;
        };
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        JupiterTestDescriptor jupiterTestDescriptor = this;
        if (jupiterTestDescriptor instanceof ResourceLockAware) {
            ResourceLockAware resourceLockAware = (ResourceLockAware)((Object)jupiterTestDescriptor);
            return resourceLockAware.determineExclusiveResources().collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) {
        context.getThrowableCollector().assertEmpty();
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluate(context.getExtensionRegistry(), context.getConfiguration(), context.getExtensionContext());
        return this.toSkipResult(evaluationResult);
    }

    private Node.SkipResult toSkipResult(ConditionEvaluationResult evaluationResult) {
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip(evaluationResult.getReason().orElse("<unknown>"));
        }
        return Node.SkipResult.doNotSkip();
    }

    @Override
    public abstract JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext var1) throws Exception;

    @Override
    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        context.close();
    }

    protected JupiterTestDescriptor copyIncludingDescendants(UnaryOperator<UniqueId> uniqueIdTransformer) {
        JupiterTestDescriptor result = this.withUniqueId(uniqueIdTransformer);
        this.getChildren().forEach(oldChild -> {
            JupiterTestDescriptor newChild = ((JupiterTestDescriptor)oldChild).copyIncludingDescendants(uniqueIdTransformer);
            result.addChild(newChild);
        });
        return result;
    }

    protected abstract JupiterTestDescriptor withUniqueId(UnaryOperator<UniqueId> var1);

    @FunctionalInterface
    static interface ExceptionHandlerInvoker<E extends Extension> {
        public void invoke(E var1, Throwable var2) throws Throwable;
    }
}

