/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.ConfigurationParameters;

class InstantiatingConfigurationParameterConverter<T> {
    private static final Logger logger = LoggerFactory.getLogger(InstantiatingConfigurationParameterConverter.class);
    private final Class<T> clazz;
    private final String name;

    public InstantiatingConfigurationParameterConverter(Class<T> clazz, String name) {
        this.clazz = clazz;
        this.name = name;
    }

    Optional<T> get(ConfigurationParameters configurationParameters, String key) {
        return this.supply(configurationParameters, key).get();
    }

    Supplier<Optional<T>> supply(ConfigurationParameters configurationParameters, String key) {
        return configurationParameters.get(key).map(String::trim).filter(className -> !className.isEmpty()).map(className -> this.newInstanceSupplier((String)className, key)).orElse(Optional::empty);
    }

    private Supplier<Optional<T>> newInstanceSupplier(String className, String key) {
        Try<Class<?>> clazz = ReflectionSupport.tryToLoadClass(className);
        return () -> clazz.andThenTry(x$0 -> ReflectionSupport.newInstance(x$0, new Object[0])).andThenTry(this.clazz::cast).ifSuccess(generator -> this.logSuccessMessage(className, key)).ifFailure(cause -> this.logFailureMessage(className, key, (Exception)cause)).toOptional();
    }

    private void logFailureMessage(String className, String key, Exception cause) {
        logger.warn(cause, () -> String.format("Failed to load default %s class '%s' set via the '%s' configuration parameter. Falling back to default behavior.", this.name, className, key));
    }

    private void logSuccessMessage(String className, String key) {
        logger.config(() -> "Using default %s '%s' set via the '%s' configuration parameter.".formatted(this.name, className, key));
    }
}

