/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.junit.jupiter.api.condition.AbstractJreCondition;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.platform.commons.util.Preconditions;

abstract class AbstractJreRangeCondition<A extends Annotation>
extends BooleanExecutionCondition<A> {
    private static final JRE DEFAULT_MINIMUM_JRE = JRE.JAVA_17;
    private static final JRE DEFAULT_MAXIMUM_JRE = JRE.OTHER;

    AbstractJreRangeCondition(Class<A> annotationType, Function<A, String> customDisabledReason) {
        super(annotationType, AbstractJreCondition.ENABLED_ON_CURRENT_JRE, AbstractJreCondition.DISABLED_ON_CURRENT_JRE, customDisabledReason);
    }

    protected final boolean isCurrentVersionWithinRange(JRE minJre, JRE maxJre, int minVersion, int maxVersion) {
        String annotationName = this.annotationType.getSimpleName();
        boolean minJreSet = minJre != JRE.UNDEFINED;
        boolean maxJreSet = maxJre != JRE.UNDEFINED;
        boolean minVersionSet = minVersion != -1;
        boolean maxVersionSet = maxVersion != -1;
        Preconditions.condition(!minJreSet || !minVersionSet, () -> "@%s's minimum value must be configured with either a JRE enum constant or numeric version, but not both".formatted(annotationName));
        Preconditions.condition(!maxJreSet || !maxVersionSet, () -> "@%s's maximum value must be configured with either a JRE enum constant or numeric version, but not both".formatted(annotationName));
        Preconditions.condition(!minVersionSet || minVersion >= 8, () -> "@%s's minVersion [%d] must be greater than or equal to %d".formatted(annotationName, minVersion, 8));
        Preconditions.condition(!maxVersionSet || maxVersion >= 8, () -> "@%s's maxVersion [%d] must be greater than or equal to %d".formatted(annotationName, maxVersion, 8));
        if (!minJreSet) {
            minJre = DEFAULT_MINIMUM_JRE;
        }
        if (!maxJreSet) {
            maxJre = DEFAULT_MAXIMUM_JRE;
        }
        int min = minVersionSet ? minVersion : minJre.version();
        int max = maxVersionSet ? maxVersion : maxJre.version();
        Preconditions.condition(min != DEFAULT_MINIMUM_JRE.version() || max != DEFAULT_MAXIMUM_JRE.version(), () -> "You must declare a non-default value for the minimum or maximum value in @" + annotationName);
        Preconditions.condition(min <= max, () -> "@%s's minimum value [%d] must be less than or equal to its maximum value [%d]".formatted(annotationName, min, max));
        return JRE.isCurrentVersionWithinRange(min, max);
    }
}

