/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.platform.commons.util.Preconditions;

abstract class AbstractJreCondition<A extends Annotation>
extends BooleanExecutionCondition<A> {
    static final String ENABLED_ON_CURRENT_JRE = "Enabled on JRE version: " + System.getProperty("java.version");
    static final String DISABLED_ON_CURRENT_JRE = "Disabled on JRE version: " + System.getProperty("java.version");

    AbstractJreCondition(Class<A> annotationType, Function<A, String> customDisabledReason) {
        super(annotationType, ENABLED_ON_CURRENT_JRE, DISABLED_ON_CURRENT_JRE, customDisabledReason);
    }

    protected final IntStream validatedVersions(JRE[] jres, int[] versions) {
        String annotationName = this.annotationType.getSimpleName();
        Preconditions.condition(jres.length > 0 || versions.length > 0, () -> "You must declare at least one JRE or version in @" + annotationName);
        Preconditions.condition(Arrays.stream(jres).noneMatch(Predicate.isEqual((Object)JRE.UNDEFINED)), () -> "JRE.UNDEFINED is not supported in @" + annotationName);
        Arrays.stream(versions).min().ifPresent(version -> Preconditions.condition(version >= 8, () -> "Version [%d] in @%s must be greater than or equal to %d".formatted(version, annotationName, 8)));
        return IntStream.concat(Arrays.stream(jres).mapToInt(JRE::version), Arrays.stream(versions)).distinct();
    }
}

