/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.net.URI;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="5.3")
public class DynamicTest
extends DynamicNode {
    private final Executable executable;

    public static DynamicTest dynamicTest(String displayName, Executable executable) {
        return new DynamicTest(displayName, null, executable);
    }

    public static DynamicTest dynamicTest(String displayName, @Nullable URI testSourceUri, Executable executable) {
        return new DynamicTest(displayName, testSourceUri, executable);
    }

    public static <T> Stream<DynamicTest> stream(Iterator<T> inputGenerator, Function<? super T, String> displayNameGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputGenerator, "inputGenerator must not be null");
        return DynamicTest.stream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(inputGenerator, 16), false), displayNameGenerator, testExecutor);
    }

    @API(status=API.Status.MAINTAINED, since="5.7")
    public static <T> Stream<DynamicTest> stream(Stream<T> inputStream, Function<? super T, String> displayNameGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputStream, "inputStream must not be null");
        Preconditions.notNull(displayNameGenerator, "displayNameGenerator must not be null");
        Preconditions.notNull(testExecutor, "testExecutor must not be null");
        return inputStream.map(input -> DynamicTest.dynamicTest((String)displayNameGenerator.apply(input), () -> testExecutor.accept(input)));
    }

    @API(status=API.Status.MAINTAINED, since="5.8")
    public static <T> Stream<DynamicTest> stream(Iterator<? extends Named<T>> inputGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputGenerator, "inputGenerator must not be null");
        return DynamicTest.stream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(inputGenerator, 16), false), testExecutor);
    }

    @API(status=API.Status.MAINTAINED, since="5.8")
    public static <T> Stream<DynamicTest> stream(Stream<? extends Named<T>> inputStream, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputStream, "inputStream must not be null");
        Preconditions.notNull(testExecutor, "testExecutor must not be null");
        return inputStream.map(input -> DynamicTest.dynamicTest(input.getName(), () -> testExecutor.accept((Object)input.getPayload())));
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public static <T extends Named<E>, E extends Executable> Stream<DynamicTest> stream(Iterator<? extends T> iterator) {
        Preconditions.notNull(iterator, "iterator must not be null");
        return DynamicTest.stream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public static <T extends Named<E>, E extends Executable> Stream<DynamicTest> stream(Stream<? extends T> inputStream) {
        Preconditions.notNull(inputStream, "inputStream must not be null");
        return inputStream.map(input -> DynamicTest.dynamicTest(input.getName(), (Executable)input.getPayload()));
    }

    private DynamicTest(String displayName, @Nullable URI testSourceUri, Executable executable) {
        super(displayName, testSourceUri);
        this.executable = Preconditions.notNull(executable, "executable must not be null");
    }

    public Executable getExecutable() {
        return this.executable;
    }
}

