/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.opentest4j.AssertionFailedError;

class AssertArrayEquals {
    private AssertArrayEquals() {
    }

    static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual, @Nullable Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, (String)null);
    }

    static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, null, (Object)message);
    }

    static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, null, messageSupplier);
    }

    static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, (Object)message);
    }

    static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, (String)null);
    }

    static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, null, (Object)message);
    }

    static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, null, messageSupplier);
    }

    static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, (String)null);
    }

    static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual, @Nullable String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, new ArrayDeque<Integer>(), (Object)message);
    }

    static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual, Supplier<@Nullable String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, new ArrayDeque<Integer>(), messageSupplier);
    }

    private static void assertArrayEquals(boolean @Nullable [] expected, boolean @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(char @Nullable [] expected, char @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            AssertArrayEquals.failArraysNotEqual(Character.valueOf(expected[i2]), Character.valueOf(actual[i2]), AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(byte @Nullable [] expected, byte @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(short @Nullable [] expected, short @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(int @Nullable [] expected, int @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(long @Nullable [] expected, long @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (expected[i2] == actual[i2]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (AssertionUtils.floatsAreEqual(expected[i2], actual[i2])) continue;
            AssertArrayEquals.failArraysNotEqual(Float.valueOf(expected[i2]), Float.valueOf(actual[i2]), AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(float @Nullable [] expected, float @Nullable [] actual, float delta, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        AssertionUtils.assertValidDelta(delta);
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (AssertionUtils.floatsAreEqual(expected[i2], actual[i2], delta)) continue;
            AssertArrayEquals.failArraysNotEqual(Float.valueOf(expected[i2]), Float.valueOf(actual[i2]), AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (AssertionUtils.doublesAreEqual(expected[i2], actual[i2])) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(double @Nullable [] expected, double @Nullable [] actual, double delta, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        AssertionUtils.assertValidDelta(delta);
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (AssertionUtils.doublesAreEqual(expected[i2], actual[i2], delta)) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i2], actual[i2], AssertArrayEquals.nullSafeIndexes(indexes, i2), messageOrSupplier);
        }
    }

    private static void assertArrayEquals(@Nullable Object @Nullable [] expected, @Nullable Object @Nullable [] actual, Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
        }
        if (actual == null) {
            throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
        }
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageOrSupplier);
        for (int i2 = 0; i2 < expected.length; ++i2) {
            Object expectedElement = expected[i2];
            Object actualElement = actual[i2];
            if (expectedElement == actualElement) continue;
            indexes.addLast(i2);
            AssertArrayEquals.assertArrayElementsEqual(expectedElement, actualElement, indexes, messageOrSupplier);
            indexes.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void assertArrayElementsEqual(@Nullable Object expected, @Nullable Object actual, Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected instanceof Object[]) {
            Object[] expectedArray = (Object[])expected;
            if (actual instanceof Object[]) {
                Object[] actualArray = (Object[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof byte[]) {
            byte[] expectedArray = (byte[])expected;
            if (actual instanceof byte[]) {
                byte[] actualArray = (byte[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof short[]) {
            short[] expectedArray = (short[])expected;
            if (actual instanceof short[]) {
                short[] actualArray = (short[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof int[]) {
            int[] expectedArray = (int[])expected;
            if (actual instanceof int[]) {
                int[] actualArray = (int[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof long[]) {
            long[] expectedArray = (long[])expected;
            if (actual instanceof long[]) {
                long[] actualArray = (long[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof char[]) {
            char[] expectedArray = (char[])expected;
            if (actual instanceof char[]) {
                char[] actualArray = (char[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof float[]) {
            float[] expectedArray = (float[])expected;
            if (actual instanceof float[]) {
                float[] actualArray = (float[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof double[]) {
            double[] expectedArray = (double[])expected;
            if (actual instanceof double[]) {
                double[] actualArray = (double[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (expected instanceof boolean[]) {
            boolean[] expectedArray = (boolean[])expected;
            if (actual instanceof boolean[]) {
                boolean[] actualArray = (boolean[])actual;
                AssertArrayEquals.assertArrayEquals(expectedArray, actualArray, indexes, messageOrSupplier);
                return;
            }
        }
        if (Objects.equals(expected, actual)) return;
        if (expected == null && ReflectionUtils.isArray(actual)) {
            AssertArrayEquals.failExpectedArrayIsNull(indexes, messageOrSupplier);
            return;
        }
        if (ReflectionUtils.isArray(expected) && actual == null) {
            AssertArrayEquals.failActualArrayIsNull(indexes, messageOrSupplier);
            return;
        }
        AssertArrayEquals.failArraysNotEqual(expected, actual, indexes, messageOrSupplier);
    }

    private static void failExpectedArrayIsNull(@Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        throw AssertArrayEquals.expectedArrayIsNullFailure(indexes, messageOrSupplier);
    }

    private static AssertionFailedError expectedArrayIsNullFailure(@Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        return AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("expected array was <null>" + AssertionUtils.formatIndexes(indexes)).build();
    }

    private static void failActualArrayIsNull(@Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        throw AssertArrayEquals.actualArrayIsNullFailure(indexes, messageOrSupplier);
    }

    private static AssertionFailedError actualArrayIsNullFailure(@Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        return AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("actual array was <null>" + AssertionUtils.formatIndexes(indexes)).build();
    }

    private static void assertArraysHaveSameLength(int expected, int actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        if (expected != actual) {
            AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("array lengths differ" + AssertionUtils.formatIndexes(indexes)).expected(expected).actual(actual).buildAndThrow();
        }
    }

    private static void failArraysNotEqual(@Nullable Object expected, @Nullable Object actual, @Nullable Deque<Integer> indexes, @Nullable Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("array contents differ" + AssertionUtils.formatIndexes(indexes)).expected(expected).actual(actual).buildAndThrow();
    }

    private static Deque<Integer> nullSafeIndexes(@Nullable Deque<Integer> indexes, int newIndex) {
        ArrayDeque<Integer> result = indexes != null ? indexes : new ArrayDeque<Integer>();
        result.addLast(newIndex);
        return result;
    }
}

