/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.console.options.ConsoleUtils;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.Theme;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(status=API.Status.INTERNAL, since="1.0")
public class CommandLineOptions {
    static final String DEFAULT_DETAILS_NAME = "tree";
    static final Details DEFAULT_DETAILS = Details.valueOf("tree".toUpperCase(Locale.ROOT));
    static final Theme DEFAULT_THEME = Theme.valueOf(ConsoleUtils.charset());
    private boolean displayHelp;
    private boolean listEngines;
    private boolean ansiColorOutputDisabled;
    private Path colorPalettePath;
    private boolean isSingleColorPalette;
    private boolean bannerDisabled;
    private Details details = DEFAULT_DETAILS;
    private Theme theme = DEFAULT_THEME;
    private List<Path> additionalClasspathEntries = Collections.emptyList();
    private boolean failIfNoTests;
    private boolean scanClasspath;
    private List<Path> selectedClasspathEntries = Collections.emptyList();
    private boolean scanModulepath;
    private List<ModuleSelector> selectedModules = Collections.emptyList();
    private List<UriSelector> selectedUris = Collections.emptyList();
    private List<FileSelector> selectedFiles = Collections.emptyList();
    private List<DirectorySelector> selectedDirectories = Collections.emptyList();
    private List<PackageSelector> selectedPackages = Collections.emptyList();
    private List<ClassSelector> selectedClasses = Collections.emptyList();
    private List<MethodSelector> selectedMethods = Collections.emptyList();
    private List<ClasspathResourceSelector> selectedClasspathResources = Collections.emptyList();
    private List<IterationSelector> selectedIterations = Collections.emptyList();
    private List<String> includedClassNamePatterns = Collections.singletonList("^(Test.*|.+[.$]Test.*|.*Tests?)$");
    private List<String> excludedClassNamePatterns = Collections.emptyList();
    private List<String> includedPackages = Collections.emptyList();
    private List<String> excludedPackages = Collections.emptyList();
    private List<String> includedEngines = Collections.emptyList();
    private List<String> excludedEngines = Collections.emptyList();
    private List<String> includedTagExpressions = Collections.emptyList();
    private List<String> excludedTagExpressions = Collections.emptyList();
    private Path reportsDir;
    private Map<String, String> configurationParameters = Collections.emptyMap();

    public boolean isDisplayHelp() {
        return this.displayHelp;
    }

    public void setDisplayHelp(boolean displayHelp) {
        this.displayHelp = displayHelp;
    }

    public boolean isListEngines() {
        return this.listEngines;
    }

    public void setListEngines(boolean listEngines) {
        this.listEngines = listEngines;
    }

    public boolean isAnsiColorOutputDisabled() {
        return this.ansiColorOutputDisabled;
    }

    public void setAnsiColorOutputDisabled(boolean ansiColorOutputDisabled) {
        this.ansiColorOutputDisabled = ansiColorOutputDisabled;
    }

    public Path getColorPalettePath() {
        return this.colorPalettePath;
    }

    public void setColorPalettePath(Path colorPalettePath) {
        this.colorPalettePath = colorPalettePath;
    }

    public boolean isSingleColorPalette() {
        return this.isSingleColorPalette;
    }

    public void setSingleColorPalette(boolean singleColorPalette) {
        this.isSingleColorPalette = singleColorPalette;
    }

    public boolean isBannerDisabled() {
        return this.bannerDisabled;
    }

    public void setBannerDisabled(boolean bannerDisabled) {
        this.bannerDisabled = bannerDisabled;
    }

    public boolean isScanModulepath() {
        return this.scanModulepath;
    }

    public void setScanModulepath(boolean scanModulepath) {
        this.scanModulepath = scanModulepath;
    }

    public boolean isScanClasspath() {
        return this.scanClasspath;
    }

    public void setScanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
    }

    public Details getDetails() {
        return this.details;
    }

    public void setDetails(Details details) {
        this.details = details;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public List<Path> getExistingAdditionalClasspathEntries() {
        return this.additionalClasspathEntries.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    public List<Path> getAdditionalClasspathEntries() {
        return this.additionalClasspathEntries;
    }

    public void setAdditionalClasspathEntries(List<Path> additionalClasspathEntries) {
        this.additionalClasspathEntries = additionalClasspathEntries;
    }

    public boolean isFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public List<Path> getSelectedClasspathEntries() {
        return this.selectedClasspathEntries;
    }

    public void setSelectedClasspathEntries(List<Path> selectedClasspathEntries) {
        this.selectedClasspathEntries = selectedClasspathEntries;
    }

    public List<UriSelector> getSelectedUris() {
        return this.selectedUris;
    }

    public void setSelectedUris(List<UriSelector> selectedUris) {
        this.selectedUris = selectedUris;
    }

    public List<FileSelector> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFiles(List<FileSelector> selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public List<DirectorySelector> getSelectedDirectories() {
        return this.selectedDirectories;
    }

    public void setSelectedDirectories(List<DirectorySelector> selectedDirectories) {
        this.selectedDirectories = selectedDirectories;
    }

    public List<ModuleSelector> getSelectedModules() {
        return this.selectedModules;
    }

    public void setSelectedModules(List<ModuleSelector> selectedModules) {
        this.selectedModules = selectedModules;
    }

    public List<PackageSelector> getSelectedPackages() {
        return this.selectedPackages;
    }

    public void setSelectedPackages(List<PackageSelector> selectedPackages) {
        this.selectedPackages = selectedPackages;
    }

    public List<ClassSelector> getSelectedClasses() {
        return this.selectedClasses;
    }

    public void setSelectedClasses(List<ClassSelector> selectedClasses) {
        this.selectedClasses = selectedClasses;
    }

    public List<MethodSelector> getSelectedMethods() {
        return this.selectedMethods;
    }

    public void setSelectedMethods(List<MethodSelector> selectedMethods) {
        this.selectedMethods = selectedMethods;
    }

    public List<ClasspathResourceSelector> getSelectedClasspathResources() {
        return this.selectedClasspathResources;
    }

    public void setSelectedClasspathResources(List<ClasspathResourceSelector> selectedClasspathResources) {
        this.selectedClasspathResources = selectedClasspathResources;
    }

    public List<IterationSelector> getSelectedIterations() {
        return this.selectedIterations;
    }

    public void setSelectedIterations(List<IterationSelector> selectedIterations) {
        this.selectedIterations = selectedIterations;
    }

    public List<DiscoverySelector> getExplicitSelectors() {
        ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
        selectors.addAll(this.getSelectedUris());
        selectors.addAll(this.getSelectedFiles());
        selectors.addAll(this.getSelectedDirectories());
        selectors.addAll(this.getSelectedModules());
        selectors.addAll(this.getSelectedPackages());
        selectors.addAll(this.getSelectedClasses());
        selectors.addAll(this.getSelectedMethods());
        selectors.addAll(this.getSelectedClasspathResources());
        selectors.addAll(this.getSelectedIterations());
        return selectors;
    }

    public List<String> getIncludedClassNamePatterns() {
        return this.includedClassNamePatterns;
    }

    public void setIncludedClassNamePatterns(List<String> includedClassNamePatterns) {
        this.includedClassNamePatterns = includedClassNamePatterns;
    }

    public List<String> getExcludedClassNamePatterns() {
        return this.excludedClassNamePatterns;
    }

    public void setExcludedClassNamePatterns(List<String> excludedClassNamePatterns) {
        this.excludedClassNamePatterns = excludedClassNamePatterns;
    }

    public List<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(List<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public List<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public List<String> getIncludedEngines() {
        return this.includedEngines;
    }

    public void setIncludedEngines(List<String> includedEngines) {
        this.includedEngines = includedEngines;
    }

    public List<String> getExcludedEngines() {
        return this.excludedEngines;
    }

    public void setExcludedEngines(List<String> excludedEngines) {
        this.excludedEngines = excludedEngines;
    }

    public List<String> getIncludedTagExpressions() {
        return this.includedTagExpressions;
    }

    public void setIncludedTagExpressions(List<String> includedTags) {
        this.includedTagExpressions = includedTags;
    }

    public List<String> getExcludedTagExpressions() {
        return this.excludedTagExpressions;
    }

    public void setExcludedTagExpressions(List<String> excludedTags) {
        this.excludedTagExpressions = excludedTags;
    }

    public Optional<Path> getReportsDir() {
        return Optional.ofNullable(this.reportsDir);
    }

    public void setReportsDir(Path reportsDir) {
        this.reportsDir = reportsDir;
    }

    public Map<String, String> getConfigurationParameters() {
        return this.configurationParameters;
    }

    public void setConfigurationParameters(Map<String, String> configurationParameters) {
        this.configurationParameters = configurationParameters;
    }
}

