/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.FilePosition;

@API(status=API.Status.STABLE, since="1.0")
public class ClasspathResourceSelector
implements DiscoverySelector {
    private final String classpathResourceName;
    private final FilePosition position;

    ClasspathResourceSelector(String classpathResourceName, FilePosition position) {
        boolean startsWithSlash = classpathResourceName.startsWith("/");
        this.classpathResourceName = startsWithSlash ? classpathResourceName.substring(1) : classpathResourceName;
        this.position = position;
    }

    public String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    public Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.position);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResourceSelector that = (ClasspathResourceSelector)o;
        return Objects.equals(this.classpathResourceName, that.classpathResourceName) && Objects.equals(this.position, that.position);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.classpathResourceName, this.position);
    }

    public String toString() {
        return new ToStringBuilder(this).append("classpathResourceName", this.classpathResourceName).append("position", this.position).toString();
    }
}

