/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.open.xml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.CompositeTestSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.descriptor.PackageSource;
import org.junit.platform.engine.support.descriptor.UriSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.OutputDir;
import org.junit.platform.reporting.open.xml.JUnitFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.DocumentWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.CoreFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Result;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Sources;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.JavaFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.root.Events;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.root.RootFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;

@API(status=API.Status.EXPERIMENTAL, since="1.9")
public class OpenTestReportGeneratingListener
implements TestExecutionListener {
    static final String ENABLED_PROPERTY_NAME = "junit.platform.reporting.open.xml.enabled";
    static final String OUTPUT_DIR_PROPERTY_NAME = "junit.platform.reporting.output.dir";
    private static final NamespaceRegistry NAMESPACE_REGISTRY = NamespaceRegistry.builder(Namespace.REPORTING_CORE).add("e", Namespace.REPORTING_EVENTS).add("java", Namespace.REPORTING_JAVA).add("junit", JUnitFactory.NAMESPACE, "https://junit.org/junit5/schemas/open-test-reporting/junit-1.9.xsd").build();
    private final AtomicInteger idCounter = new AtomicInteger();
    private final Map<UniqueId, String> inProgressIds = new ConcurrentHashMap<UniqueId, String>();
    private DocumentWriter<Events> eventsFileWriter = DocumentWriter.noop();

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        ConfigurationParameters config = testPlan.getConfigurationParameters();
        if (this.isEnabled(config).booleanValue()) {
            Path eventsXml = OutputDir.create(config.get(OUTPUT_DIR_PROPERTY_NAME)).createFile("junit-platform-events", "xml");
            try {
                this.eventsFileWriter = Events.createDocumentWriter(NAMESPACE_REGISTRY, eventsXml);
                this.reportInfrastructure();
            }
            catch (Exception e) {
                throw new JUnitException("Failed to initialize XML events file: " + eventsXml, e);
            }
        }
    }

    private Boolean isEnabled(ConfigurationParameters config) {
        return config.getBoolean(ENABLED_PROPERTY_NAME).orElse(false);
    }

    private void reportInfrastructure() {
        this.eventsFileWriter.append(CoreFactory.infrastructure(), infrastructure -> {
            try {
                String hostName = InetAddress.getLocalHost().getHostName();
                infrastructure.append(CoreFactory.hostName(hostName));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            infrastructure.append(CoreFactory.userName(System.getProperty("user.name"))).append(CoreFactory.operatingSystem(System.getProperty("os.name"))).append(CoreFactory.cpuCores(Runtime.getRuntime().availableProcessors())).append(JavaFactory.javaVersion(System.getProperty("java.version"))).append(JavaFactory.fileEncoding(System.getProperty("file.encoding"))).append(JavaFactory.heapSize(), heapSize -> heapSize.withMax(Runtime.getRuntime().maxMemory()));
        });
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        try {
            this.eventsFileWriter.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close XML events file", e);
        }
        finally {
            this.eventsFileWriter = DocumentWriter.noop();
        }
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        String id = String.valueOf(this.idCounter.incrementAndGet());
        this.reportStarted(testIdentifier, id);
        this.eventsFileWriter.append(RootFactory.finished(id, Instant.now()), finished -> finished.append(CoreFactory.result(Result.Status.SKIPPED), result -> {
            if (StringUtils.isNotBlank(reason)) {
                result.append(CoreFactory.reason(reason));
            }
        }));
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        String id = String.valueOf(this.idCounter.incrementAndGet());
        this.inProgressIds.put(testIdentifier.getUniqueIdObject(), id);
        this.reportStarted(testIdentifier, id);
    }

    private void reportStarted(TestIdentifier testIdentifier, String id) {
        this.eventsFileWriter.append(RootFactory.started(id, Instant.now(), testIdentifier.getDisplayName()), started -> {
            testIdentifier.getParentIdObject().ifPresent(parentId -> started.withParentId(this.inProgressIds.get(parentId)));
            started.append(CoreFactory.metadata(), metadata -> {
                if (!testIdentifier.getTags().isEmpty()) {
                    metadata.append(CoreFactory.tags(), tags -> testIdentifier.getTags().forEach(tag -> tags.append(CoreFactory.tag(tag.getName()))));
                }
                metadata.append(JUnitFactory.uniqueId(testIdentifier.getUniqueId())).append(JUnitFactory.legacyReportingName(testIdentifier.getLegacyReportingName())).append(JUnitFactory.type(testIdentifier.getType()));
            });
            testIdentifier.getSource().ifPresent(source -> started.append(CoreFactory.sources(), sources -> this.addTestSource((TestSource)source, (Sources)sources)));
        });
    }

    private void addTestSource(TestSource source, Sources sources) {
        if (source instanceof CompositeTestSource) {
            ((CompositeTestSource)source).getSources().forEach(it -> this.addTestSource((TestSource)it, sources));
        } else if (source instanceof ClassSource) {
            ClassSource classSource = (ClassSource)source;
            sources.append(JavaFactory.classSource(classSource.getClassName()), element -> classSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)source;
            sources.append(JavaFactory.methodSource(methodSource.getClassName(), methodSource.getMethodName()), element -> {
                String methodParameterTypes = methodSource.getMethodParameterTypes();
                if (methodParameterTypes != null) {
                    element.withMethodParameterTypes(methodParameterTypes);
                }
            });
        } else if (source instanceof ClasspathResourceSource) {
            ClasspathResourceSource classpathResourceSource = (ClasspathResourceSource)source;
            sources.append(JavaFactory.classpathResourceSource(classpathResourceSource.getClasspathResourceName()), element -> classpathResourceSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof PackageSource) {
            sources.append(JavaFactory.packageSource(((PackageSource)source).getPackageName()));
        } else if (source instanceof FileSource) {
            FileSource fileSource = (FileSource)source;
            sources.append(CoreFactory.fileSource(fileSource.getFile()), element -> fileSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof DirectorySource) {
            sources.append(CoreFactory.directorySource(((DirectorySource)source).getFile()));
        } else if (source instanceof UriSource) {
            sources.append(CoreFactory.uriSource(((UriSource)source).getUri()));
        }
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String id = this.inProgressIds.get(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.reported(id, Instant.now()), reported -> reported.append(CoreFactory.attachments(), attachments -> attachments.append(CoreFactory.data(), data -> {
            data.withTime(entry.getTimestamp());
            entry.getKeyValuePairs().forEach(data::addEntry);
        })));
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String id = this.inProgressIds.remove(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.finished(id, Instant.now()), finished -> finished.append(CoreFactory.result(this.convertStatus(testExecutionResult.getStatus())), result -> testExecutionResult.getThrowable().ifPresent(throwable -> result.append(JavaFactory.throwable(throwable)))));
    }

    private Result.Status convertStatus(TestExecutionResult.Status status) {
        switch (status) {
            case FAILED: {
                return Result.Status.FAILED;
            }
            case SUCCESSFUL: {
                return Result.Status.SUCCESSFUL;
            }
            case ABORTED: {
                return Result.Status.ABORTED;
            }
        }
        throw new JUnitException("Unhandled status: " + (Object)((Object)status));
    }
}

