/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(factoryMethodName -> this.getMethod(context, (String)factoryMethodName)).map(method -> context.getExecutableInvoker().invoke((Method)method, (Object)testInstance)).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private Method getMethod(ExtensionContext context, String factoryMethodName) {
        if (StringUtils.isBlank(factoryMethodName)) {
            return ReflectionUtils.getRequiredMethod(context.getRequiredTestClass(), context.getRequiredTestMethod().getName(), new Class[0]);
        }
        if (factoryMethodName.contains(".") || factoryMethodName.contains("#")) {
            return this.getMethodByFullyQualifiedName(factoryMethodName);
        }
        return this.getMethodByShortName(context.getRequiredTestClass(), factoryMethodName);
    }

    private Method getMethodByFullyQualifiedName(String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        return ReflectionUtils.findMethod(this.loadRequiredClass(className), methodName, methodParameters).orElseThrow(() -> new JUnitException(String.format("Could not find method [%s(%s)] in class [%s]", methodName, methodParameters, className)));
    }

    private Method getMethodByShortName(Class<?> testClass, String methodName) {
        List<Method> methods = ReflectionUtils.findMethods(testClass, method -> method.getName().equals(methodName));
        Preconditions.condition(methods.size() > 0, () -> String.format("Could not find method [%s] in class [%s]", methodName, testClass.getName()));
        Preconditions.condition(methods.size() <= 1, () -> String.format("Several factory methods named [%s] were found in class [%s]", methodName, testClass.getName()));
        return methods.get(0);
    }

    private Class<?> loadRequiredClass(String className) {
        return ReflectionUtils.tryToLoadClass(className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray(item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

