/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.engine.config.EnumConfigurationParameterConverter;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class TempDirectory
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(TempDirectory.class);
    private static final String KEY = "temp.dir";
    private static final String TEMP_DIR_PREFIX = "junit";

    TempDirectory() {
    }

    @Override
    public void beforeAll(ExtensionContext context) {
        this.injectStaticFields(context, context.getRequiredTestClass());
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectInstanceFields(context, instance));
    }

    private void injectStaticFields(ExtensionContext context, Class<?> testClass) {
        this.injectFields(context, null, testClass, ReflectionUtils::isStatic);
    }

    private void injectInstanceFields(ExtensionContext context, Object instance) {
        this.injectFields(context, instance, instance.getClass(), ReflectionUtils::isNotStatic);
    }

    private void injectFields(ExtensionContext context, Object testInstance, Class<?> testClass, Predicate<Field> predicate) {
        AnnotationUtils.findAnnotatedFields(testClass, TempDir.class, predicate).forEach(field -> {
            this.assertSupportedType("field", field.getType());
            try {
                ReflectionUtils.makeAccessible(field).set(testInstance, this.getPathOrFile((AnnotatedElement)field, field.getType(), context));
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException(t);
            }
        });
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean annotated = parameterContext.isAnnotated(TempDir.class);
        if (annotated && parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("@TempDir is not supported on constructor parameters. Please use field injection instead.");
        }
        return annotated;
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        this.assertSupportedType("parameter", parameterType);
        return this.getPathOrFile(parameterContext.getParameter(), parameterType, extensionContext);
    }

    private void assertSupportedType(String target, Class<?> type) {
        if (type != Path.class && type != File.class) {
            throw new ExtensionConfigurationException("Can only resolve @TempDir " + target + " of type " + Path.class.getName() + " or " + File.class.getName() + " but was: " + type.getName());
        }
    }

    private Object getPathOrFile(AnnotatedElement sourceElement, Class<?> type, ExtensionContext extensionContext) {
        ExtensionContext.Namespace namespace = this.getScope(extensionContext) == Scope.PER_DECLARATION ? NAMESPACE.append(sourceElement) : NAMESPACE;
        Path path = extensionContext.getStore(namespace).getOrComputeIfAbsent(KEY, __ -> TempDirectory.createTempDir(), CloseablePath.class).get();
        return type == Path.class ? path : path.toFile();
    }

    private Scope getScope(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent(Scope.class, __ -> new EnumConfigurationParameterConverter<Scope>(Scope.class, "@TempDir scope").get("junit.jupiter.tempdir.scope", context::getConfigurationParameter, Scope.PER_DECLARATION), Scope.class);
    }

    private static CloseablePath createTempDir() {
        try {
            return new CloseablePath(Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]));
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create default temp directory", ex);
        }
    }

    static enum Scope {
        PER_CONTEXT,
        PER_DECLARATION;

    }

    private static class CloseablePath
    implements ExtensionContext.Store.CloseableResource {
        private final Path dir;

        CloseablePath(Path dir) {
            this.dir = dir;
        }

        Path get() {
            return this.dir;
        }

        @Override
        public void close() throws IOException {
            SortedMap<Path, IOException> failures = this.deleteAllFilesAndDirectories();
            if (!failures.isEmpty()) {
                throw this.createIOExceptionWithAttachedFailures(failures);
            }
        }

        private SortedMap<Path, IOException> deleteAllFilesAndDirectories() throws IOException {
            if (Files.notExists(this.dir, new LinkOption[0])) {
                return Collections.emptySortedMap();
            }
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            CloseablePath.resetPermissions(this.dir);
            Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (!dir.equals(dir)) {
                        CloseablePath.resetPermissions(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    this.resetPermissionsAndTryToDeleteAgain(file, exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    return this.deleteAndContinue(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.deleteAndContinue(dir);
                }

                private FileVisitResult deleteAndContinue(Path path) {
                    try {
                        Files.delete(path);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                    catch (DirectoryNotEmptyException exception) {
                        failures.put(path, exception);
                    }
                    catch (IOException exception) {
                        this.resetPermissionsAndTryToDeleteAgain(path, exception);
                    }
                    return FileVisitResult.CONTINUE;
                }

                private void resetPermissionsAndTryToDeleteAgain(Path path, IOException exception) {
                    try {
                        CloseablePath.resetPermissions(path);
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            Files.walkFileTree(path, this);
                        } else {
                            Files.delete(path);
                        }
                    }
                    catch (Exception suppressed) {
                        exception.addSuppressed(suppressed);
                        failures.put(path, exception);
                    }
                }
            });
            return failures;
        }

        private static void resetPermissions(Path path) {
            File file = path.toFile();
            file.setReadable(true);
            file.setWritable(true);
            if (Files.isDirectory(path, new LinkOption[0])) {
                file.setExecutable(true);
            }
        }

        private IOException createIOExceptionWithAttachedFailures(SortedMap<Path, IOException> failures) {
            String joinedPaths = failures.keySet().stream().peek(this::tryToDeleteOnExit).map(this::relativizeSafely).map(String::valueOf).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to delete temp directory " + this.dir.toAbsolutePath() + ". The following paths could not be deleted (see suppressed exceptions for details): " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            return exception;
        }

        private void tryToDeleteOnExit(Path path) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        private Path relativizeSafely(Path path) {
            try {
                return this.dir.relativize(path);
            }
            catch (IllegalArgumentException e) {
                return path;
            }
        }
    }
}

