/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.extension.RepeatedTestDisplayNameFormatter;
import org.junit.jupiter.engine.extension.RepetitionInfoParameterResolver;

class RepeatedTestInvocationContext
implements TestTemplateInvocationContext {
    private final int currentRepetition;
    private final int totalRepetitions;
    private final RepeatedTestDisplayNameFormatter formatter;

    public RepeatedTestInvocationContext(int currentRepetition, int totalRepetitions, RepeatedTestDisplayNameFormatter formatter) {
        this.currentRepetition = currentRepetition;
        this.totalRepetitions = totalRepetitions;
        this.formatter = formatter;
    }

    @Override
    public String getDisplayName(int invocationIndex) {
        return this.formatter.format(this.currentRepetition, this.totalRepetitions);
    }

    @Override
    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new RepetitionInfoParameterResolver(this.currentRepetition, this.totalRepetitions));
    }
}

