/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultClassDescriptor;
import org.junit.jupiter.engine.discovery.DefaultClassOrdererContext;
import org.junit.platform.engine.TestDescriptor;

class ClassOrderingVisitor
extends AbstractOrderingVisitor
implements TestDescriptor.Visitor {
    private final JupiterConfiguration configuration;

    public ClassOrderingVisitor(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visit(TestDescriptor testDescriptor) {
        this.configuration.getDefaultTestClassOrderer().ifPresent(testClassOrderer -> this.doWithMatchingDescriptor(JupiterEngineDescriptor.class, testDescriptor, descriptor -> this.orderContainedClasses((JupiterEngineDescriptor)descriptor, (ClassOrderer)testClassOrderer), descriptor -> "Failed to order classes"));
    }

    private void orderContainedClasses(JupiterEngineDescriptor jupiterEngineDescriptor, ClassOrderer classOrderer) {
        this.orderChildrenTestDescriptors(jupiterEngineDescriptor, ClassBasedTestDescriptor.class, DefaultClassDescriptor::new, descriptorWrappers -> classOrderer.orderClasses(new DefaultClassOrdererContext((List<? extends ClassDescriptor>)descriptorWrappers, this.configuration)), difference -> String.format("ClassOrderer [%s] added %s ClassDescriptor(s) which will be ignored.", classOrderer.getClass().getName(), difference), difference -> String.format("ClassOrderer [%s] removed %s ClassDescriptor(s) which will be retained with arbitrary ordering.", classOrderer.getClass().getName(), -difference));
    }
}

