/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.DisabledOnJre;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.platform.commons.util.Preconditions;

class DisabledOnJreCondition
extends BooleanExecutionCondition<DisabledOnJre> {
    DisabledOnJreCondition() {
        super(DisabledOnJre.class, EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE, EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE, DisabledOnJre::disabledReason);
    }

    @Override
    boolean isEnabled(DisabledOnJre annotation) {
        JRE[] versions = annotation.value();
        Preconditions.condition(versions.length > 0, "You must declare at least one JRE in @DisabledOnJre");
        return Arrays.stream(versions).noneMatch(JRE::isCurrentVersion);
    }
}

