/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(status=API.Status.INTERNAL, since="1.0")
public class ConsoleLauncherExecutionResult {
    private static final int SUCCESS = 0;
    private static final int TEST_FAILED = 1;
    private static final int NO_TESTS_FOUND = 2;
    private static final int FAILED = -1;
    private final int exitCode;
    private final TestExecutionSummary testExecutionSummary;

    public static int computeExitCode(TestExecutionSummary summary, CommandLineOptions options) {
        if (options.isFailIfNoTests() && summary.getTestsFoundCount() == 0L) {
            return 2;
        }
        return summary.getTotalFailureCount() == 0L ? 0 : 1;
    }

    static ConsoleLauncherExecutionResult success() {
        return new ConsoleLauncherExecutionResult(0, null);
    }

    static ConsoleLauncherExecutionResult failed() {
        return new ConsoleLauncherExecutionResult(-1, null);
    }

    static ConsoleLauncherExecutionResult forSummary(TestExecutionSummary summary, CommandLineOptions options) {
        int exitCode = ConsoleLauncherExecutionResult.computeExitCode(summary, options);
        return new ConsoleLauncherExecutionResult(exitCode, summary);
    }

    private ConsoleLauncherExecutionResult(int exitCode, TestExecutionSummary testExecutionSummary) {
        this.testExecutionSummary = testExecutionSummary;
        this.exitCode = exitCode;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Optional<TestExecutionSummary> getTestExecutionSummary() {
        return Optional.ofNullable(this.testExecutionSummary);
    }
}

