/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

abstract class MethodBasedCondition
implements ExecutionCondition {
    MethodBasedCondition() {
    }

    abstract Optional<String> getMethodName(ExtensionContext var1);

    abstract ConditionEvaluationResult getDefaultResult();

    abstract ConditionEvaluationResult getResultBasedOnBoolean(boolean var1);

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return this.getMethodName(context).map(methodName -> this.getConditionMethod((String)methodName, context)).map(method -> (boolean)((Boolean)this.evaluateCondition((Method)method, context))).map(this::getResultBasedOnBoolean).orElse(this.getDefaultResult());
    }

    private Method getConditionMethod(String methodName, ExtensionContext context) {
        if (methodName.contains("#")) {
            return this.findMethodByFullyQualifiedName(methodName);
        }
        return this.findMethod(context.getRequiredTestClass(), methodName);
    }

    private Method findMethodByFullyQualifiedName(String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        Class<?> clazz = ReflectionUtils.tryToLoadClass(className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
        return this.findMethod(clazz, methodName);
    }

    private Method findMethod(Class<?> clazz, String methodName) {
        return ReflectionUtils.findMethod(clazz, methodName, new Class[0]).orElseGet(() -> ReflectionUtils.getRequiredMethod(clazz, methodName, ExtensionContext.class));
    }

    private Object evaluateCondition(Method method, ExtensionContext context) {
        Preconditions.condition(method.getReturnType() == Boolean.TYPE, () -> String.format("method [%s] should return a boolean", method.getName()));
        Preconditions.condition(this.areParametersSupported(method), () -> String.format("method [%s] should take either an ExtensionContext or no parameters", method.getName()));
        Object testInstance = context.getTestInstance().orElse(null);
        if (method.getParameterCount() == 0) {
            return ReflectionUtils.invokeMethod(method, testInstance, new Object[0]);
        }
        return ReflectionUtils.invokeMethod(method, testInstance, context);
    }

    private boolean areParametersSupported(Method method) {
        switch (method.getParameterCount()) {
            case 0: {
                return true;
            }
            case 1: {
                return method.getParameterTypes()[0] == ExtensionContext.class;
            }
        }
        return false;
    }
}

