/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledForJreRangeCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledForJreRange is not present");

    EnabledForJreRangeCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), EnabledForJreRange.class).map(enabledForJreRange -> {
            JRE min = enabledForJreRange.min();
            JRE max = enabledForJreRange.max();
            Preconditions.condition(max.compareTo(min) >= 0, "@EnabledForJreRange.min must be lower or the same version as @EnabledForJreRange.max");
            if (this.isCurrentVersionWithinRange(min, max)) {
                return EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE;
            }
            return EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE;
        }).orElse(ENABLED_BY_DEFAULT);
    }

    private boolean isCurrentVersionWithinRange(JRE min, JRE max) {
        if (JRE.CURRENT_VERSION == null) {
            return true;
        }
        return JRE.CURRENT_VERSION.compareTo(min) >= 0 && JRE.CURRENT_VERSION.compareTo(max) <= 0;
    }
}

