/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.jupiter.engine.discovery.predicates.IsTestClassWithTests;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class ClassSelectorResolver
implements SelectorResolver {
    private static final IsTestClassWithTests isTestClassWithTests = new IsTestClassWithTests();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();
    private final Predicate<String> classNameFilter;
    private final JupiterConfiguration configuration;

    ClassSelectorResolver(Predicate<String> classNameFilter, JupiterConfiguration configuration) {
        this.classNameFilter = classNameFilter;
        this.configuration = configuration;
    }

    @Override
    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class<?> testClass = selector.getJavaClass();
        if (isTestClassWithTests.test(testClass)) {
            if (this.classNameFilter.test(testClass.getName())) {
                return this.toResolution(context.addToParent(parent -> Optional.of(this.newClassTestDescriptor((TestDescriptor)parent, testClass))));
            }
        } else if (isNestedTestClass.test(testClass)) {
            return this.toResolution(context.addToParent(() -> DiscoverySelectors.selectClass(testClass.getEnclosingClass()), parent -> Optional.of(this.newNestedClassTestDescriptor((TestDescriptor)parent, testClass))));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    @Override
    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId.Segment lastSegment = uniqueId.getLastSegment();
        if ("class".equals(lastSegment.getType())) {
            String className = lastSegment.getValue();
            return ReflectionUtils.tryToLoadClass(className).toOptional().filter(isTestClassWithTests).map(testClass -> this.toResolution(context.addToParent(parent -> Optional.of(this.newClassTestDescriptor((TestDescriptor)parent, (Class<?>)testClass))))).orElse(SelectorResolver.Resolution.unresolved());
        }
        if ("nested-class".equals(lastSegment.getType())) {
            String simpleClassName = lastSegment.getValue();
            return this.toResolution(context.addToParent(() -> DiscoverySelectors.selectUniqueId(uniqueId.removeLastSegment()), parent -> {
                if (parent instanceof ClassBasedTestDescriptor) {
                    Class<?> parentTestClass = ((ClassBasedTestDescriptor)parent).getTestClass();
                    return ReflectionUtils.findNestedClasses(parentTestClass, isNestedTestClass.and(FunctionUtils.where(Class::getSimpleName, Predicate.isEqual(simpleClassName)))).stream().findFirst().flatMap(testClass -> Optional.of(this.newNestedClassTestDescriptor((TestDescriptor)parent, (Class<?>)testClass)));
                }
                return Optional.empty();
            }));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private ClassTestDescriptor newClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return new ClassTestDescriptor(parent.getUniqueId().append("class", testClass.getName()), testClass, this.configuration);
    }

    private NestedClassTestDescriptor newNestedClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return new NestedClassTestDescriptor(parent.getUniqueId().append("nested-class", testClass.getSimpleName()), testClass, this.configuration);
    }

    private SelectorResolver.Resolution toResolution(Optional<? extends ClassBasedTestDescriptor> testDescriptor) {
        return testDescriptor.map(it -> {
            Class<?> testClass = it.getTestClass();
            return SelectorResolver.Resolution.match(SelectorResolver.Match.exact(it, () -> {
                Stream<MethodSelector> methods = ReflectionUtils.findMethods(testClass, IsTestClassWithTests.isTestOrTestFactoryOrTestTemplateMethod).stream().map(method -> DiscoverySelectors.selectMethod(testClass, method));
                Stream<ClassSelector> nestedClasses = ReflectionSupport.findNestedClasses(testClass, isNestedTestClass).stream().map(DiscoverySelectors::selectClass);
                return Stream.concat(methods, nestedClasses).collect(Collectors.toCollection(LinkedHashSet::new));
            }));
        }).orElse(SelectorResolver.Resolution.unresolved());
    }
}

