/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.jupiter.engine.discovery.MethodFinder;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class MethodSelectorResolver
implements SelectorResolver {
    private static final Logger logger = LoggerFactory.getLogger(MethodSelectorResolver.class);
    private static final MethodFinder methodFinder = new MethodFinder();
    protected final JupiterConfiguration configuration;

    MethodSelectorResolver(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        Set<SelectorResolver.Match> matches = Arrays.stream(MethodType.values()).map(methodType -> ((MethodType)methodType).resolveMethodSelector(selector, context, this.configuration)).filter(Optional::isPresent).map(Optional::get).map(testDescriptor -> SelectorResolver.Match.exact(testDescriptor, this.expansionCallback((TestDescriptor)testDescriptor))).collect(Collectors.toSet());
        if (matches.size() > 1) {
            logger.warn(() -> {
                Stream<TestDescriptor> testDescriptors = matches.stream().map(SelectorResolver.Match::getTestDescriptor);
                return String.format("Possible configuration error: method [%s] resulted in multiple TestDescriptors %s. This is typically the result of annotating a method with multiple competing annotations such as @Test, @RepeatedTest, @ParameterizedTest, @TestFactory, etc.", selector.getJavaMethod().toGenericString(), testDescriptors.map(d -> d.getClass().getName()).collect(Collectors.toList()));
            });
        }
        return matches.isEmpty() ? SelectorResolver.Resolution.unresolved() : SelectorResolver.Resolution.matches(matches);
    }

    @Override
    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        return Arrays.stream(MethodType.values()).map(methodType -> ((MethodType)methodType).resolveUniqueIdIntoTestDescriptor(uniqueId, context, this.configuration)).filter(Optional::isPresent).map(Optional::get).map(testDescriptor -> {
            boolean exactMatch = uniqueId.equals(testDescriptor.getUniqueId());
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)((Object)testDescriptor);
                if (exactMatch) {
                    filterable.getDynamicDescendantFilter().allowAll();
                } else {
                    filterable.getDynamicDescendantFilter().allow(uniqueId);
                }
            }
            return SelectorResolver.Resolution.match(exactMatch ? SelectorResolver.Match.exact(testDescriptor) : SelectorResolver.Match.partial(testDescriptor, this.expansionCallback((TestDescriptor)testDescriptor)));
        }).findFirst().orElse(SelectorResolver.Resolution.unresolved());
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(TestDescriptor testDescriptor) {
        return () -> {
            if (testDescriptor instanceof Filterable) {
                ((Filterable)((Object)testDescriptor)).getDynamicDescendantFilter().allowAll();
            }
            return Collections.emptySet();
        };
    }

    private static enum MethodType {
        TEST((Predicate)new IsTestMethod(), "method", new String[0]){

            @Override
            protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method, JupiterConfiguration configuration) {
                return new TestMethodTestDescriptor(uniqueId, testClass, method, configuration);
            }
        }
        ,
        TEST_FACTORY((Predicate)new IsTestFactoryMethod(), "test-factory", new String[]{"dynamic-container", "dynamic-test"}){

            @Override
            protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method, JupiterConfiguration configuration) {
                return new TestFactoryTestDescriptor(uniqueId, testClass, method, configuration);
            }
        }
        ,
        TEST_TEMPLATE((Predicate)new IsTestTemplateMethod(), "test-template", new String[]{"test-template-invocation"}){

            @Override
            protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method, JupiterConfiguration configuration) {
                return new TestTemplateTestDescriptor(uniqueId, testClass, method, configuration);
            }
        };

        private final Predicate<Method> methodPredicate;
        private final String segmentType;
        private final Set<String> dynamicDescendantSegmentTypes;

        private MethodType(Predicate<Method> methodPredicate, String segmentType, String ... dynamicDescendantSegmentTypes) {
            this.methodPredicate = methodPredicate;
            this.segmentType = segmentType;
            this.dynamicDescendantSegmentTypes = new LinkedHashSet<String>(Arrays.asList(dynamicDescendantSegmentTypes));
        }

        private Optional<TestDescriptor> resolveMethodSelector(MethodSelector selector, SelectorResolver.Context resolver, JupiterConfiguration configuration) {
            if (!this.methodPredicate.test(selector.getJavaMethod())) {
                return Optional.empty();
            }
            Class<?> testClass = selector.getJavaClass();
            Method method = selector.getJavaMethod();
            return resolver.addToParent(() -> DiscoverySelectors.selectClass(testClass), parent -> Optional.of(this.createTestDescriptor(this.createUniqueId(method, (TestDescriptor)parent), testClass, method, configuration)));
        }

        private Optional<TestDescriptor> resolveUniqueIdIntoTestDescriptor(UniqueId uniqueId, SelectorResolver.Context context, JupiterConfiguration configuration) {
            UniqueId.Segment lastSegment = uniqueId.getLastSegment();
            if (this.segmentType.equals(lastSegment.getType())) {
                return context.addToParent(() -> DiscoverySelectors.selectUniqueId(uniqueId.removeLastSegment()), parent -> {
                    String methodSpecPart = lastSegment.getValue();
                    Class<?> testClass = ((ClassTestDescriptor)parent).getTestClass();
                    return methodFinder.findMethod(methodSpecPart, testClass).filter(this.methodPredicate).map(method -> this.createTestDescriptor(this.createUniqueId((Method)method, (TestDescriptor)parent), testClass, (Method)method, configuration));
                });
            }
            if (this.dynamicDescendantSegmentTypes.contains(lastSegment.getType())) {
                return this.resolveUniqueIdIntoTestDescriptor(uniqueId.removeLastSegment(), context, configuration);
            }
            return Optional.empty();
        }

        private UniqueId createUniqueId(Method method, TestDescriptor parent) {
            String methodId = String.format("%s(%s)", method.getName(), ClassUtils.nullSafeToString(method.getParameterTypes()));
            return parent.getUniqueId().append(this.segmentType, methodId);
        }

        protected abstract TestDescriptor createTestDescriptor(UniqueId var1, Class<?> var2, Method var3, JupiterConfiguration var4);
    }
}

