/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassExtensionContext;
import org.junit.jupiter.engine.descriptor.DefaultTestInstanceFactoryContext;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.LifecycleMethodUtils;
import org.junit.jupiter.engine.descriptor.TestInstanceLifecycleUtils;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.DefaultTestInstances;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.TestInstancesProvider;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public class ClassTestDescriptor
extends JupiterTestDescriptor {
    public static final String SEGMENT_TYPE = "class";
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    private final Class<?> testClass;
    private final Set<TestTag> tags;
    protected final TestInstance.Lifecycle lifecycle;
    private Node.ExecutionMode defaultChildExecutionMode;
    private TestInstanceFactory testInstanceFactory;
    private List<Method> beforeAllMethods;
    private List<Method> afterAllMethods;

    public ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, JupiterConfiguration configuration) {
        this(uniqueId, testClass, DisplayNameUtils.createDisplayNameSupplierForClass(testClass), configuration);
    }

    ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, Supplier<String> displayNameSupplier, JupiterConfiguration configuration) {
        super(uniqueId, testClass, displayNameSupplier, ClassSource.from(testClass), configuration);
        this.testClass = testClass;
        this.tags = ClassTestDescriptor.getTags(testClass);
        this.lifecycle = TestInstanceLifecycleUtils.getTestInstanceLifecycle(testClass, configuration);
        this.defaultChildExecutionMode = this.lifecycle == TestInstance.Lifecycle.PER_CLASS ? Node.ExecutionMode.SAME_THREAD : null;
    }

    @Override
    public Set<TestTag> getTags() {
        return new LinkedHashSet<TestTag>(this.tags);
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public String getLegacyReportingName() {
        return this.testClass.getName();
    }

    @Override
    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.getExecutionModeFromAnnotation(this.getTestClass());
    }

    @Override
    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return Optional.ofNullable(this.defaultChildExecutionMode);
    }

    public void setDefaultChildExecutionMode(Node.ExecutionMode defaultChildExecutionMode) {
        this.defaultChildExecutionMode = defaultChildExecutionMode;
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return this.getExclusiveResourcesFromAnnotation(this.getTestClass());
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.testClass);
        ExtensionUtils.registerExtensionsFromFields(registry, this.testClass, null);
        this.testInstanceFactory = this.resolveTestInstanceFactory(registry);
        this.registerBeforeEachMethodAdapters(registry);
        this.registerAfterEachMethodAdapters(registry);
        ThrowableCollector throwableCollector = JupiterThrowableCollectorFactory.createThrowableCollector();
        ClassExtensionContext extensionContext = new ClassExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, this.lifecycle, context.getConfiguration(), throwableCollector);
        this.beforeAllMethods = LifecycleMethodUtils.findBeforeAllMethods(this.testClass, this.lifecycle == TestInstance.Lifecycle.PER_METHOD);
        this.afterAllMethods = LifecycleMethodUtils.findAfterAllMethods(this.testClass, this.lifecycle == TestInstance.Lifecycle.PER_METHOD);
        return context.extend().withTestInstancesProvider(this.testInstancesProvider(context, registry, extensionContext)).withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
    }

    @Override
    public JupiterEngineExecutionContext before(JupiterEngineExecutionContext context) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        TestInstance.Lifecycle lifecycle = context.getExtensionContext().getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
        if (lifecycle == TestInstance.Lifecycle.PER_CLASS) {
            ClassExtensionContext extensionContext = (ClassExtensionContext)context.getExtensionContext();
            throwableCollector.execute(() -> extensionContext.setTestInstances(context.getTestInstancesProvider().getTestInstances(Optional.empty())));
        }
        if (throwableCollector.isEmpty()) {
            context.beforeAllCallbacksExecuted(true);
            this.invokeBeforeAllCallbacks(context);
            if (throwableCollector.isEmpty()) {
                context.beforeAllMethodsExecuted(true);
                this.invokeBeforeAllMethods(context);
            }
        }
        throwableCollector.assertEmpty();
        return context;
    }

    @Override
    public void after(JupiterEngineExecutionContext context) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Throwable previousThrowable = throwableCollector.getThrowable();
        if (context.beforeAllMethodsExecuted()) {
            this.invokeAfterAllMethods(context);
        }
        if (context.beforeAllCallbacksExecuted()) {
            this.invokeAfterAllCallbacks(context);
        }
        if (previousThrowable != throwableCollector.getThrowable()) {
            throwableCollector.assertEmpty();
        }
    }

    private TestInstanceFactory resolveTestInstanceFactory(ExtensionRegistry registry) {
        List<TestInstanceFactory> factories = registry.getExtensions(TestInstanceFactory.class);
        if (factories.size() == 1) {
            return factories.get(0);
        }
        if (factories.size() > 1) {
            String factoryNames = factories.stream().map(factory -> factory.getClass().getName()).collect(Collectors.joining(", "));
            String errorMessage = String.format("The following TestInstanceFactory extensions were registered for test class [%s], but only one is permitted: %s", this.testClass.getName(), factoryNames);
            throw new ExtensionConfigurationException(errorMessage);
        }
        return null;
    }

    private TestInstancesProvider testInstancesProvider(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ClassExtensionContext extensionContext) {
        TestInstancesProvider testInstancesProvider = childRegistry -> this.instantiateAndPostProcessTestInstance(parentExecutionContext, extensionContext, childRegistry.orElse(registry));
        return childRegistry -> extensionContext.getTestInstances().orElseGet(() -> testInstancesProvider.getTestInstances(childRegistry));
    }

    private TestInstances instantiateAndPostProcessTestInstance(JupiterEngineExecutionContext parentExecutionContext, ExtensionContext extensionContext, ExtensionRegistry registry) {
        TestInstances instances = this.instantiateTestClass(parentExecutionContext, registry, extensionContext);
        this.invokeTestInstancePostProcessors(instances.getInnermostInstance(), registry, extensionContext);
        ExtensionUtils.registerExtensionsFromFields(registry, this.testClass, instances.getInnermostInstance());
        return instances;
    }

    protected TestInstances instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        return this.instantiateTestClass(Optional.empty(), registry, extensionContext);
    }

    protected TestInstances instantiateTestClass(Optional<TestInstances> outerInstances, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Optional<Object> outerInstance = outerInstances.map(TestInstances::getInnermostInstance);
        Object instance = this.testInstanceFactory != null ? this.invokeTestInstanceFactory(outerInstance, extensionContext) : this.invokeTestClassConstructor(outerInstance, registry, extensionContext);
        return outerInstances.map(instances -> DefaultTestInstances.of(instances, instance)).orElse(DefaultTestInstances.of(instance));
    }

    private Object invokeTestInstanceFactory(Optional<Object> outerInstance, ExtensionContext extensionContext) {
        Object instance;
        try {
            instance = this.testInstanceFactory.createTestInstance(new DefaultTestInstanceFactoryContext(this.testClass, outerInstance), extensionContext);
        }
        catch (Throwable throwable) {
            BlacklistedExceptions.rethrowIfBlacklisted(throwable);
            if (throwable instanceof TestInstantiationException) {
                throw (TestInstantiationException)throwable;
            }
            String message = String.format("TestInstanceFactory [%s] failed to instantiate test class [%s]", this.testInstanceFactory.getClass().getName(), this.testClass.getName());
            if (StringUtils.isNotBlank(throwable.getMessage())) {
                message = message + ": " + throwable.getMessage();
            }
            throw new TestInstantiationException(message, throwable);
        }
        if (!this.testClass.isInstance(instance)) {
            String instanceClassName;
            String testClassName = this.testClass.getName();
            Class<?> instanceClass = instance == null ? null : instance.getClass();
            String string = instanceClassName = instanceClass == null ? "null" : instanceClass.getName();
            if (testClassName.equals(instanceClassName)) {
                testClassName = testClassName + "@" + Integer.toHexString(System.identityHashCode(this.testClass));
                instanceClassName = instanceClassName + "@" + Integer.toHexString(System.identityHashCode(instanceClass));
            }
            String message = String.format("TestInstanceFactory [%s] failed to return an instance of [%s] and instead returned an instance of [%s].", this.testInstanceFactory.getClass().getName(), testClassName, instanceClassName);
            throw new TestInstantiationException(message);
        }
        return instance;
    }

    private Object invokeTestClassConstructor(Optional<Object> outerInstance, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Constructor<?> constructor = ReflectionUtils.getDeclaredConstructor(this.testClass);
        return outerInstance.isPresent() ? executableInvoker.invoke(constructor, outerInstance.get(), extensionContext, registry) : executableInvoker.invoke(constructor, extensionContext, registry);
    }

    private void invokeTestInstancePostProcessors(Object instance, ExtensionRegistry registry, ExtensionContext context) {
        registry.stream(TestInstancePostProcessor.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.postProcessTestInstance(instance, context)));
    }

    private void invokeBeforeAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (BeforeAllCallback callback : registry.getExtensions(BeforeAllCallback.class)) {
            throwableCollector.execute(() -> callback.beforeAll(extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeBeforeAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        for (Method method : this.beforeAllMethods) {
            throwableCollector.execute(() -> executableInvoker.invoke(method, testInstance, extensionContext, registry));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeAfterAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        this.afterAllMethods.forEach(method -> throwableCollector.execute(() -> executableInvoker.invoke((Method)method, (Object)testInstance, extensionContext, registry)));
    }

    private void invokeAfterAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        registry.getReversedExtensions(AfterAllCallback.class).forEach(extension -> throwableCollector.execute(() -> extension.afterAll(extensionContext)));
    }

    private void registerBeforeEachMethodAdapters(ExtensionRegistry registry) {
        List<Method> beforeEachMethods = LifecycleMethodUtils.findBeforeEachMethods(this.testClass);
        this.registerMethodsAsExtensions(beforeEachMethods, registry, this::synthesizeBeforeEachMethodAdapter);
    }

    private void registerAfterEachMethodAdapters(ExtensionRegistry registry) {
        ArrayList<Method> afterEachMethods = new ArrayList<Method>(LifecycleMethodUtils.findAfterEachMethods(this.testClass));
        Collections.reverse(afterEachMethods);
        this.registerMethodsAsExtensions(afterEachMethods, registry, this::synthesizeAfterEachMethodAdapter);
    }

    private void registerMethodsAsExtensions(List<Method> methods, ExtensionRegistry registry, Function<Method, Extension> extensionSynthesizer) {
        methods.forEach(method -> registry.registerExtension((Extension)extensionSynthesizer.apply((Method)method), method));
    }

    private BeforeEachMethodAdapter synthesizeBeforeEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry);
    }

    private AfterEachMethodAdapter synthesizeAfterEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry);
    }

    private void invokeMethodInExtensionContext(Method method, ExtensionContext context, ExtensionRegistry registry) {
        TestInstances testInstances = context.getRequiredTestInstances();
        Object target = testInstances.findInstance(method.getDeclaringClass()).orElseThrow(() -> new JUnitException("Failed to find instance for method: " + method.toGenericString()));
        executableInvoker.invoke(method, target, context, registry);
    }
}

