/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.support.io;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.support.io.DefaultTempDirContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.EXPERIMENTAL, since="5.4")
public final class TempDirectory
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(TempDirectory.class);
    private static final String KEY = "temp.dir";
    private static final String TEMP_DIR_PREFIX = "junit";
    private final TempDirProvider tempDirProvider;

    private TempDirectory(TempDirProvider tempDirProvider) {
        this.tempDirProvider = Preconditions.notNull(tempDirProvider, "TempDirProvider must not be null");
    }

    public TempDirectory() {
        this((__, ___, dirPrefix) -> TempDirectory.createDefaultTempDir(dirPrefix));
    }

    public static TempDirectory createInDefaultDirectory() {
        return new TempDirectory();
    }

    public static TempDirectory createInCustomDirectory(ParentDirProvider parentDirProvider) {
        Preconditions.notNull(parentDirProvider, "ParentDirProvider must not be null");
        return new TempDirectory((tempDirContext, extensionContext, dirPrefix) -> TempDirectory.createCustomTempDir(parentDirProvider, tempDirContext, extensionContext, dirPrefix));
    }

    public static TempDirectory createInCustomDirectory(Callable<Path> parentDirProvider) {
        Preconditions.notNull(parentDirProvider, "parentDirProvider must not be null");
        return TempDirectory.createInCustomDirectory((TempDirContext tempDirContext, ExtensionContext extensionContext) -> (Path)parentDirProvider.call());
    }

    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        this.injectFields(context, null, ReflectionUtils::isStatic);
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        this.injectFields(context, context.getRequiredTestInstance(), ReflectionUtils::isNotStatic);
    }

    private void injectFields(ExtensionContext context, Object testInstance, Predicate<Field> predicate) {
        AnnotationUtils.findAnnotatedFields(context.getRequiredTestClass(), TempDir.class, predicate).forEach(field -> {
            this.assertValidFieldCandidate((Field)field);
            try {
                ReflectionUtils.makeAccessible(field).set(testInstance, this.getPathOrFile(field.getType(), DefaultTempDirContext.from(field), context));
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException(t);
            }
        });
    }

    private void assertValidFieldCandidate(Field field) {
        this.assertSupportedType("field", field.getType());
        if (ReflectionUtils.isPrivate(field)) {
            throw new ExtensionConfigurationException("@TempDir field [" + field + "] must not be private.");
        }
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        if (parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("@TempDir is not supported on constructor parameters. Please use field injection instead.");
        }
        return parameterContext.isAnnotated(TempDir.class);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        this.assertSupportedType("parameter", parameterType);
        return this.getPathOrFile(parameterType, DefaultTempDirContext.from(parameterContext), extensionContext);
    }

    private void assertSupportedType(String target, Class<?> type) {
        if (type != Path.class && type != File.class) {
            throw new ExtensionConfigurationException("Can only resolve @TempDir " + target + " of type " + Path.class.getName() + " or " + File.class.getName() + " but was: " + type.getName());
        }
    }

    private Object getPathOrFile(Class<?> type, TempDirContext tempDirContext, ExtensionContext extensionContext) {
        Path path = extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent(KEY, key -> this.tempDirProvider.get(tempDirContext, extensionContext, TEMP_DIR_PREFIX), CloseablePath.class).get();
        if (type == Path.class) {
            return path;
        }
        try {
            return path.toFile();
        }
        catch (UnsupportedOperationException ex) {
            String message = String.format("The configured FileSystem does not support conversion to a %s; declare a %s instead.", File.class.getName(), Path.class.getName());
            throw new ExtensionConfigurationException(message, ex);
        }
    }

    private static CloseablePath createDefaultTempDir(String dirPrefix) {
        try {
            return new CloseablePath(Files.createTempDirectory(dirPrefix, new FileAttribute[0]));
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create default temp directory", ex);
        }
    }

    private static CloseablePath createCustomTempDir(ParentDirProvider parentDirProvider, TempDirContext tempDirContext, ExtensionContext extensionContext, String dirPrefix) {
        Path parentDir;
        try {
            parentDir = parentDirProvider.get(tempDirContext, extensionContext);
            Preconditions.notNull(parentDir, "ParentDirProvider returned null for the parent directory");
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to get parent directory from provider", ex);
        }
        try {
            return new CloseablePath(Files.createTempDirectory(parentDir, dirPrefix, new FileAttribute[0]));
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create custom temp directory", ex);
        }
    }

    private static class CloseablePath
    implements ExtensionContext.Store.CloseableResource {
        private final Path dir;

        CloseablePath(Path dir) {
            this.dir = dir;
        }

        Path get() {
            return this.dir;
        }

        @Override
        public void close() throws IOException {
            SortedMap<Path, IOException> failures = this.deleteAllFilesAndDirectories();
            if (!failures.isEmpty()) {
                throw this.createIOExceptionWithAttachedFailures(failures);
            }
        }

        private SortedMap<Path, IOException> deleteAllFilesAndDirectories() throws IOException {
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    return this.deleteAndContinue(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.deleteAndContinue(dir);
                }

                private FileVisitResult deleteAndContinue(Path path) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ex) {
                        failures.put(path, ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return failures;
        }

        private IOException createIOExceptionWithAttachedFailures(SortedMap<Path, IOException> failures) {
            String joinedPaths = failures.keySet().stream().peek(this::tryToDeleteOnExit).map(this::relativizeSafely).map(String::valueOf).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to delete temp directory " + this.dir.toAbsolutePath() + ". The following paths could not be deleted (see suppressed exceptions for details): " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            return exception;
        }

        private void tryToDeleteOnExit(Path path) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        private Path relativizeSafely(Path path) {
            try {
                return this.dir.relativize(path);
            }
            catch (IllegalArgumentException e) {
                return path;
            }
        }
    }

    @FunctionalInterface
    private static interface TempDirProvider {
        public CloseablePath get(TempDirContext var1, ExtensionContext var2, String var3);
    }

    @FunctionalInterface
    public static interface ParentDirProvider {
        public Path get(TempDirContext var1, ExtensionContext var2) throws Exception;
    }

    public static interface TempDirContext {
        public AnnotatedElement getElement();

        public Optional<Field> getField();

        public Optional<ParameterContext> getParameterContext();

        public boolean isAnnotated(Class<? extends Annotation> var1);

        public <A extends Annotation> Optional<A> findAnnotation(Class<A> var1);

        public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> var1);
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface TempDir {
    }
}

