/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public final class MethodExtensionContext
extends AbstractExtensionContext<TestMethodTestDescriptor> {
    private final TestInstances testInstances;
    private final ThrowableCollector throwableCollector;

    public MethodExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestMethodTestDescriptor testDescriptor, JupiterConfiguration configuration, TestInstances testInstances, ThrowableCollector throwableCollector) {
        super(parent, engineExecutionListener, testDescriptor, configuration);
        this.testInstances = testInstances;
        this.throwableCollector = throwableCollector;
    }

    @Override
    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((TestMethodTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Class<?>> getTestClass() {
        return Optional.of(((TestMethodTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return this.getParent().flatMap(ExtensionContext::getTestInstanceLifecycle);
    }

    @Override
    public Optional<Object> getTestInstance() {
        return Optional.of(this.testInstances.getInnermostInstance());
    }

    @Override
    public Optional<TestInstances> getTestInstances() {
        return Optional.of(this.testInstances);
    }

    @Override
    public Optional<Method> getTestMethod() {
        return Optional.of(((TestMethodTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }
}

