/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NodeTestTaskContext;
import org.junit.platform.engine.support.hierarchical.NodeUtils;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class NodeTestTask<C extends EngineExecutionContext>
implements HierarchicalTestExecutorService.TestTask {
    private final NodeTestTaskContext taskContext;
    private final TestDescriptor testDescriptor;
    private final Node<C> node;
    private C parentContext;
    private C context;
    private Node.SkipResult skipResult;
    private boolean started;
    private ThrowableCollector throwableCollector;

    NodeTestTask(NodeTestTaskContext taskContext, TestDescriptor testDescriptor) {
        this.taskContext = taskContext;
        this.testDescriptor = testDescriptor;
        this.node = NodeUtils.asNode(testDescriptor);
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.taskContext.getExecutionAdvisor().getResourceLock(this.testDescriptor);
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.taskContext.getExecutionAdvisor().getForcedExecutionMode(this.testDescriptor).orElse(this.node.getExecutionMode());
    }

    void setParentContext(C parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void execute() {
        this.throwableCollector = this.taskContext.getThrowableCollectorFactory().create();
        this.prepare();
        if (this.throwableCollector.isEmpty()) {
            this.checkWhetherSkipped();
        }
        if (this.throwableCollector.isEmpty() && !this.skipResult.isSkipped()) {
            this.executeRecursively();
        }
        if (this.context != null) {
            this.cleanUp();
        }
        this.reportCompletion();
    }

    private void prepare() {
        this.throwableCollector.execute(() -> {
            this.context = this.node.prepare(this.parentContext);
        });
        this.parentContext = null;
    }

    private void checkWhetherSkipped() {
        this.throwableCollector.execute(() -> {
            this.skipResult = this.node.shouldBeSkipped(this.context);
        });
    }

    private void executeRecursively() {
        this.taskContext.getListener().executionStarted(this.testDescriptor);
        this.started = true;
        this.throwableCollector.execute(() -> {
            List children = this.testDescriptor.getChildren().stream().map(descriptor -> new NodeTestTask<C>(this.taskContext, (TestDescriptor)descriptor)).collect(Collectors.toCollection(ArrayList::new));
            this.context = this.node.before(this.context);
            ArrayList futures = new ArrayList();
            this.context = this.node.execute(this.context, dynamicTestDescriptor -> this.executeDynamicTest(dynamicTestDescriptor, futures));
            if (!children.isEmpty()) {
                children.forEach(child -> child.setParentContext(this.context));
                this.taskContext.getExecutorService().invokeAll(children);
            }
            for (Future future : futures) {
                future.get();
            }
        });
        this.throwableCollector.execute(() -> this.node.after(this.context));
    }

    private void executeDynamicTest(TestDescriptor dynamicTestDescriptor, List<Future<?>> futures) {
        this.taskContext.getListener().dynamicTestRegistered(dynamicTestDescriptor);
        Set<ExclusiveResource> exclusiveResources = NodeUtils.asNode(dynamicTestDescriptor).getExclusiveResources();
        if (!exclusiveResources.isEmpty()) {
            this.taskContext.getListener().executionStarted(dynamicTestDescriptor);
            String message = "Dynamic test descriptors must not declare exclusive resources: " + exclusiveResources;
            this.taskContext.getListener().executionFinished(dynamicTestDescriptor, TestExecutionResult.failed(new JUnitException(message)));
        } else {
            NodeTestTask<C> nodeTestTask = new NodeTestTask<C>(this.taskContext, dynamicTestDescriptor);
            nodeTestTask.setParentContext(this.context);
            futures.add(this.taskContext.getExecutorService().submit(nodeTestTask));
        }
    }

    private void cleanUp() {
        this.throwableCollector.execute(() -> this.node.cleanUp(this.context));
        this.context = null;
    }

    private void reportCompletion() {
        if (this.throwableCollector.isEmpty() && this.skipResult.isSkipped()) {
            this.taskContext.getListener().executionSkipped(this.testDescriptor, this.skipResult.getReason().orElse("<unknown>"));
            return;
        }
        if (!this.started) {
            this.taskContext.getListener().executionStarted(this.testDescriptor);
        }
        this.taskContext.getListener().executionFinished(this.testDescriptor, this.throwableCollector.toTestExecutionResult());
        this.throwableCollector = null;
    }
}

