/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.engine.extension.DisabledCondition;
import org.junit.jupiter.engine.extension.RepeatedTestExtension;
import org.junit.jupiter.engine.extension.ScriptExecutionCondition;
import org.junit.jupiter.engine.extension.TestInfoParameterResolver;
import org.junit.jupiter.engine.extension.TestReporterParameterResolver;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.ConfigurationParameters;

@API(status=API.Status.INTERNAL, since="5.0")
public class ExtensionRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionRegistry.class);
    private static final List<Extension> DEFAULT_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(new DisabledCondition(), new ScriptExecutionCondition(), new RepeatedTestExtension(), new TestInfoParameterResolver(), new TestReporterParameterResolver()));
    private final ExtensionRegistry parent;
    private final Set<Class<? extends Extension>> registeredExtensionTypes = new LinkedHashSet<Class<? extends Extension>>();
    private final List<Extension> registeredExtensions = new ArrayList<Extension>();

    public static ExtensionRegistry createRegistryWithDefaultExtensions(ConfigurationParameters configParams) {
        ExtensionRegistry extensionRegistry = new ExtensionRegistry(null);
        logger.trace(() -> "Registering default extensions: " + DEFAULT_EXTENSIONS.stream().map(extension -> extension.getClass().getName()).collect(Collectors.toList()));
        DEFAULT_EXTENSIONS.forEach(extensionRegistry::registerDefaultExtension);
        if (configParams.getBoolean("junit.jupiter.extensions.autodetection.enabled").orElse(Boolean.FALSE).booleanValue()) {
            ExtensionRegistry.registerAutoDetectedExtensions(extensionRegistry);
        }
        return extensionRegistry;
    }

    private static void registerAutoDetectedExtensions(ExtensionRegistry extensionRegistry) {
        ServiceLoader<Extension> extensions = ServiceLoader.load(Extension.class, ClassLoaderUtils.getDefaultClassLoader());
        logger.config(() -> "Registering auto-detected extensions: " + StreamSupport.stream(extensions.spliterator(), false).map(extension -> extension.getClass().getName()).collect(Collectors.toList()));
        extensions.forEach(extensionRegistry::registerDefaultExtension);
    }

    public static ExtensionRegistry createRegistryFrom(ExtensionRegistry parentRegistry, List<Class<? extends Extension>> extensionTypes) {
        Preconditions.notNull(parentRegistry, "parentRegistry must not be null");
        ExtensionRegistry registry = new ExtensionRegistry(parentRegistry);
        extensionTypes.forEach(registry::registerExtension);
        return registry;
    }

    private ExtensionRegistry(ExtensionRegistry parent) {
        this.parent = parent;
    }

    public ExtensionRegistry getParent() {
        return this.parent;
    }

    public <E extends Extension> Stream<E> stream(Class<E> extensionType) {
        if (this.parent == null) {
            return this.streamLocal(extensionType);
        }
        return Stream.concat(this.parent.stream(extensionType), this.streamLocal(extensionType));
    }

    private <E extends Extension> Stream<E> streamLocal(Class<E> extensionType) {
        return this.registeredExtensions.stream().filter(extensionType::isInstance).map(extensionType::cast);
    }

    public <E extends Extension> List<E> getExtensions(Class<E> extensionType) {
        return this.stream(extensionType).collect(Collectors.toCollection(ArrayList::new));
    }

    public <E extends Extension> List<E> getLocalExtensions(Class<E> extensionType) {
        return this.streamLocal(extensionType).collect(Collectors.toCollection(ArrayList::new));
    }

    public <E extends Extension> List<E> getReversedExtensions(Class<E> extensionType) {
        List<E> extensions = this.getExtensions(extensionType);
        Collections.reverse(extensions);
        return extensions;
    }

    private boolean isAlreadyRegistered(Class<? extends Extension> extensionType) {
        return this.registeredExtensionTypes.contains(extensionType) || this.parent != null && this.parent.isAlreadyRegistered(extensionType);
    }

    void registerExtension(Class<? extends Extension> extensionType) {
        if (!this.isAlreadyRegistered(extensionType)) {
            this.registerExtension(ReflectionUtils.newInstance(extensionType, new Object[0]));
            this.registeredExtensionTypes.add(extensionType);
        }
    }

    private void registerDefaultExtension(Extension extension) {
        this.registeredExtensions.add(extension);
        this.registeredExtensionTypes.add(extension.getClass());
    }

    private void registerExtension(Extension extension) {
        this.registerExtension(extension, extension);
    }

    public void registerExtension(Extension extension, Object source) {
        logger.trace(() -> String.format("Registering extension [%s] from source [%s].", extension, source));
        this.registeredExtensions.add(extension);
    }
}

