/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.net.URI;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.EXPERIMENTAL, since="5.0")
public abstract class DynamicNode {
    private final String displayName;
    private final URI testSourceUri;

    DynamicNode(String displayName, URI testSourceUri) {
        this.displayName = Preconditions.notBlank(displayName, "displayName must not be null or blank");
        this.testSourceUri = testSourceUri;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Optional<URI> getTestSourceUri() {
        return Optional.ofNullable(this.testSourceUri);
    }

    public String toString() {
        return new ToStringBuilder(this).append("displayName", this.displayName).append("testSourceUri", this.testSourceUri).toString();
    }
}

