/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.Color;
import org.junit.platform.console.tasks.TreeNode;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;

class TreePrinter {
    private final PrintWriter out;
    private final Theme theme;
    private final boolean disableAnsiColors;

    TreePrinter(PrintWriter out, Theme theme, boolean disableAnsiColors) {
        this.out = out;
        this.theme = theme;
        this.disableAnsiColors = disableAnsiColors;
    }

    void print(TreeNode node) {
        this.out.println(this.color(Color.CONTAINER, this.theme.root()));
        this.print(node, "", true);
        this.out.flush();
    }

    private void print(TreeNode node, String indent, boolean continuous) {
        if (node.visible) {
            this.printVisible(node, indent, continuous);
        }
        if (node.children.isEmpty()) {
            return;
        }
        if (node.visible) {
            indent = indent + (continuous ? this.theme.vertical() : this.theme.blank());
        }
        Iterator<TreeNode> iterator = node.children.iterator();
        while (iterator.hasNext()) {
            this.print(iterator.next(), indent, iterator.hasNext());
        }
    }

    private void printVisible(TreeNode node, String indent, boolean continuous) {
        String bullet = continuous ? this.theme.entry() : this.theme.end();
        String prefix = this.color(Color.CONTAINER, indent + bullet);
        String tabbed = this.color(Color.CONTAINER, indent + (continuous ? this.theme.vertical() : this.theme.blank()) + this.theme.blank());
        String caption = this.colorCaption(node);
        String duration = this.color(Color.CONTAINER, node.duration + " ms");
        String icon = this.color(Color.SKIPPED, this.theme.skipped());
        if (node.result().isPresent()) {
            TestExecutionResult result2 = node.result().get();
            Color resultColor = Color.valueOf(result2);
            icon = this.color(resultColor, this.theme.status(result2));
        }
        this.out.print(prefix);
        this.out.print(" ");
        this.out.print(caption);
        if (node.duration > 10000L && node.children.isEmpty()) {
            this.out.print(" ");
            this.out.print(duration);
        }
        this.out.print(" ");
        this.out.print(icon);
        node.result().ifPresent(result -> this.printThrowable(tabbed, (TestExecutionResult)result));
        node.reason().ifPresent(reason -> this.printMessage(Color.SKIPPED, tabbed, (String)reason));
        node.reports.forEach(e -> this.printReportEntry(tabbed, (ReportEntry)e));
        this.out.println();
    }

    private String colorCaption(TreeNode node) {
        String caption = node.caption();
        if (node.result().isPresent()) {
            TestExecutionResult result = node.result().get();
            Color resultColor = Color.valueOf(result);
            if (result.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
                return this.color(resultColor, caption);
            }
        }
        if (node.reason().isPresent()) {
            return this.color(Color.SKIPPED, caption);
        }
        Color color = node.identifier().map(Color::valueOf).orElse(Color.NONE);
        return this.color(color, caption);
    }

    private void printThrowable(String indent, TestExecutionResult result) {
        if (!result.getThrowable().isPresent()) {
            return;
        }
        Throwable throwable = result.getThrowable().get();
        String message = throwable.getMessage();
        if (StringUtils.isBlank(message)) {
            message = throwable.toString();
        }
        this.printMessage(Color.FAILED, indent, message);
    }

    private void printReportEntry(String indent, ReportEntry reportEntry) {
        this.out.println();
        this.out.print(indent);
        this.out.print(reportEntry.getTimestamp());
        Set<Map.Entry<String, String>> entries = reportEntry.getKeyValuePairs().entrySet();
        if (entries.size() == 1) {
            this.printReportEntry(" ", CollectionUtils.getOnlyElement(entries));
            return;
        }
        for (Map.Entry<String, String> entry : entries) {
            this.out.println();
            this.printReportEntry(indent + this.theme.blank(), entry);
        }
    }

    private void printReportEntry(String indent, Map.Entry<String, String> mapEntry) {
        this.out.print(indent);
        this.out.print(this.color(Color.YELLOW, mapEntry.getKey()));
        this.out.print(" = `");
        this.out.print(this.color(Color.GREEN, mapEntry.getValue()));
        this.out.print("`");
    }

    private void printMessage(Color color, String indent, String message) {
        String[] lines = message.split("\\R");
        this.out.print(" ");
        this.out.print(this.color(color, lines[0]));
        if (lines.length > 1) {
            for (int i2 = 1; i2 < lines.length; ++i2) {
                this.out.println();
                this.out.print(indent);
                if (!StringUtils.isNotBlank(lines[i2])) continue;
                String extra = this.theme.blank();
                this.out.print(this.color(color, extra + lines[i2]));
            }
        }
    }

    private String color(Color color, String text) {
        if (this.disableAnsiColors || color == Color.NONE) {
            return text;
        }
        return color.toString() + text + Color.NONE.toString();
    }
}

