/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.LinkedHashSet;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.discovery.DiscoveryFilterApplier;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.JavaElementsResolver;
import org.junit.jupiter.engine.discovery.NestedTestsResolver;
import org.junit.jupiter.engine.discovery.TestContainerResolver;
import org.junit.jupiter.engine.discovery.TestFactoryMethodResolver;
import org.junit.jupiter.engine.discovery.TestMethodResolver;
import org.junit.jupiter.engine.discovery.TestTemplateMethodResolver;
import org.junit.jupiter.engine.discovery.predicates.IsTestClassWithTests;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;

@API(status=API.Status.INTERNAL, since="5.0")
public class DiscoverySelectorResolver {
    private static final IsTestClassWithTests isTestClassWithTests = new IsTestClassWithTests();

    public void resolveSelectors(EngineDiscoveryRequest request, TestDescriptor engineDescriptor) {
        ClassFilter classFilter = ClasspathScanningSupport.buildClassFilter(request, isTestClassWithTests);
        this.resolve(request, engineDescriptor, classFilter);
        this.filter(engineDescriptor, classFilter);
        this.pruneTree(engineDescriptor);
    }

    private void resolve(EngineDiscoveryRequest request, TestDescriptor engineDescriptor, ClassFilter classFilter) {
        JavaElementsResolver javaElementsResolver = this.createJavaElementsResolver(engineDescriptor, classFilter);
        request.getSelectorsByType(ClasspathRootSelector.class).forEach(javaElementsResolver::resolveClasspathRoot);
        request.getSelectorsByType(ModuleSelector.class).forEach(javaElementsResolver::resolveModule);
        request.getSelectorsByType(PackageSelector.class).forEach(javaElementsResolver::resolvePackage);
        request.getSelectorsByType(ClassSelector.class).forEach(javaElementsResolver::resolveClass);
        request.getSelectorsByType(MethodSelector.class).forEach(javaElementsResolver::resolveMethod);
        request.getSelectorsByType(UniqueIdSelector.class).forEach(javaElementsResolver::resolveUniqueId);
    }

    private void filter(TestDescriptor engineDescriptor, ClassFilter classFilter) {
        new DiscoveryFilterApplier().applyClassNamePredicate(classFilter::match, engineDescriptor);
    }

    private void pruneTree(TestDescriptor rootDescriptor) {
        rootDescriptor.accept(TestDescriptor::prune);
    }

    private JavaElementsResolver createJavaElementsResolver(TestDescriptor engineDescriptor, ClassFilter classFilter) {
        LinkedHashSet<ElementResolver> resolvers = new LinkedHashSet<ElementResolver>();
        resolvers.add(new TestContainerResolver());
        resolvers.add(new NestedTestsResolver());
        resolvers.add(new TestMethodResolver());
        resolvers.add(new TestFactoryMethodResolver());
        resolvers.add(new TestTemplateMethodResolver());
        return new JavaElementsResolver(engineDescriptor, classFilter, resolvers);
    }
}

