/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.discovery.VintageDiscoverer;
import org.junit.vintage.engine.execution.RunnerExecutor;

@API(status=API.Status.INTERNAL, since="4.12")
public final class VintageTestEngine
implements TestEngine {
    @Override
    public String getId() {
        return "junit-vintage";
    }

    @Override
    public Optional<String> getGroupId() {
        return Optional.of("org.junit.vintage");
    }

    @Override
    public Optional<String> getArtifactId() {
        return Optional.of("junit-vintage-engine");
    }

    @Override
    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        return new VintageDiscoverer().discover(discoveryRequest, uniqueId);
    }

    @Override
    public void execute(ExecutionRequest request) {
        EngineExecutionListener engineExecutionListener = request.getEngineExecutionListener();
        TestDescriptor engineTestDescriptor = request.getRootTestDescriptor();
        engineExecutionListener.executionStarted(engineTestDescriptor);
        RunnerExecutor runnerExecutor = new RunnerExecutor(engineExecutionListener);
        this.executeAllChildren(runnerExecutor, engineTestDescriptor);
        engineExecutionListener.executionFinished(engineTestDescriptor, TestExecutionResult.successful());
    }

    private void executeAllChildren(RunnerExecutor runnerExecutor, TestDescriptor engineTestDescriptor) {
        engineTestDescriptor.getChildren().stream().map(RunnerTestDescriptor.class::cast).forEach(runnerExecutor::execute);
    }
}

