/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.AbstractConversionMapping;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.AllIndexesSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldEnumSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldIndexSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldNameSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSet;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.Conversion;

public class FieldConversionMapping {
    private static final Conversion[] EMPTY_CONVERSION_ARRAY = new Conversion[0];
    private final List<FieldSelector> conversionSequence = new ArrayList<FieldSelector>();
    private final AbstractConversionMapping<String> fieldNameConversionMapping = new AbstractConversionMapping<String>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldNameSelector();
        }
    };
    private final AbstractConversionMapping<Integer> fieldIndexConversionMapping = new AbstractConversionMapping<Integer>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldIndexSelector();
        }
    };
    private final AbstractConversionMapping<Enum> fieldEnumConversionMapping = new AbstractConversionMapping<Enum>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldEnumSelector();
        }
    };
    private final AbstractConversionMapping<Integer> convertAllMapping = new AbstractConversionMapping<Integer>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new AllIndexesSelector();
        }
    };
    private Map<Integer, List<Conversion<?, ?>>> conversionsByIndex = Collections.emptyMap();

    public void prepareExecution(boolean writing, String[] values) {
        if (this.fieldNameConversionMapping.isEmpty() && this.fieldEnumConversionMapping.isEmpty() && this.fieldIndexConversionMapping.isEmpty() && this.convertAllMapping.isEmpty()) {
            return;
        }
        if (!this.conversionsByIndex.isEmpty()) {
            return;
        }
        this.conversionsByIndex = new HashMap();
        for (FieldSelector next : this.conversionSequence) {
            this.fieldNameConversionMapping.prepareExecution(writing, next, this.conversionsByIndex, values);
            this.fieldIndexConversionMapping.prepareExecution(writing, next, this.conversionsByIndex, values);
            this.fieldEnumConversionMapping.prepareExecution(writing, next, this.conversionsByIndex, values);
            this.convertAllMapping.prepareExecution(writing, next, this.conversionsByIndex, values);
        }
    }

    public void applyConversionsOnAllFields(Conversion<String, ?> ... conversions) {
        this.convertAllMapping.registerConversions(conversions);
    }

    public FieldSet<Integer> applyConversionsOnFieldIndexes(Conversion<String, ?> ... conversions) {
        return this.fieldIndexConversionMapping.registerConversions(conversions);
    }

    public FieldSet<String> applyConversionsOnFieldNames(Conversion<String, ?> ... conversions) {
        return this.fieldNameConversionMapping.registerConversions(conversions);
    }

    public FieldSet<Enum> applyConversionsOnFieldEnums(Conversion<String, ?> ... conversions) {
        return this.fieldEnumConversionMapping.registerConversions(conversions);
    }

    public Object reverseConversions(boolean executeInReverseOrder, int index, Object value, boolean[] convertedFlags) {
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index);
        if (conversions != null) {
            if (convertedFlags != null) {
                convertedFlags[index] = true;
            }
            Conversion<?, ?> conversion = null;
            try {
                if (executeInReverseOrder) {
                    for (int i2 = conversions.size() - 1; i2 >= 0; --i2) {
                        conversion = conversions.get(i2);
                        value = conversion.revert(value);
                    }
                } else {
                    for (Conversion<?, ?> c : conversions) {
                        conversion = c;
                        value = conversion.revert(value);
                    }
                }
            }
            catch (DataProcessingException ex) {
                ex.setValue(value);
                ex.setColumnIndex(index);
                ex.markAsNonFatal();
                throw ex;
            }
            catch (Throwable ex) {
                DataProcessingException exception = conversion != null ? new DataProcessingException("Error converting value '{value}' using conversion " + conversion.getClass().getName(), ex) : new DataProcessingException("Error converting value '{value}'", ex);
                exception.setValue(value);
                exception.setColumnIndex(index);
                exception.markAsNonFatal();
                throw exception;
            }
        }
        return value;
    }

    public Object applyConversions(int index, String stringValue, boolean[] convertedFlags) {
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index);
        if (conversions != null) {
            if (convertedFlags != null) {
                convertedFlags[index] = true;
            }
            String result = stringValue;
            for (Conversion<?, ?> conversion : conversions) {
                try {
                    result = conversion.execute(result);
                }
                catch (DataProcessingException ex) {
                    ex.setColumnIndex(index);
                    ex.markAsNonFatal();
                    throw ex;
                }
                catch (Throwable ex) {
                    DataProcessingException exception = new DataProcessingException("Error converting value '{value}' using conversion " + conversion.getClass().getName(), ex);
                    exception.setValue(result);
                    exception.setColumnIndex(index);
                    exception.markAsNonFatal();
                    throw exception;
                }
            }
            return result;
        }
        return stringValue;
    }

    public Conversion[] getConversions(int index, Class<?> expectedType) {
        Conversion[] out;
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index);
        if (conversions != null) {
            out = new Conversion[conversions.size()];
            int i2 = 0;
            for (Conversion<?, ?> conversion : conversions) {
                out[i2++] = conversion;
            }
        } else {
            if (expectedType == String.class) {
                return EMPTY_CONVERSION_ARRAY;
            }
            out = new Conversion[]{AnnotationHelper.getDefaultConversion(expectedType, null, null)};
            if (out[0] == null) {
                return EMPTY_CONVERSION_ARRAY;
            }
        }
        return out;
    }
}

