/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.ParameterizedTestParameterResolver;

class ParameterizedTestInvocationContext
implements TestTemplateInvocationContext {
    private final ParameterizedTestNameFormatter formatter;
    private final Object[] arguments;

    ParameterizedTestInvocationContext(ParameterizedTestNameFormatter formatter, Object[] arguments) {
        this.formatter = formatter;
        this.arguments = arguments;
    }

    @Override
    public String getDisplayName(int invocationIndex) {
        return this.formatter.format(invocationIndex, this.arguments);
    }

    @Override
    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new ParameterizedTestParameterResolver(this.arguments));
    }
}

