/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.DetailsConverter;
import org.junit.platform.console.options.KeyValuePairConverter;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.options.ThemeConverter;
import org.junit.platform.console.options.UriConverter;
import org.junit.platform.console.shadow.joptsimple.OptionParser;
import org.junit.platform.console.shadow.joptsimple.OptionSet;
import org.junit.platform.console.shadow.joptsimple.OptionSpec;
import org.junit.platform.console.shadow.joptsimple.util.KeyValuePair;
import org.junit.platform.console.shadow.joptsimple.util.PathConverter;
import org.junit.platform.console.shadow.joptsimple.util.PathProperties;

class AvailableOptions {
    private static final String CP_OPTION = "cp";
    private final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> help = this.parser.acceptsAll(Arrays.asList("h", "help"), "Display help information.");
    private final OptionSpec<Void> disableAnsiColors = this.parser.accepts("disable-ansi-colors", "Disable ANSI colors in output (not supported by all terminals).");
    private final OptionSpec<Details> details = this.parser.accepts("details", "Select an output details mode for when tests are executed. Use one of: " + Arrays.asList(Details.values()) + ". If '" + (Object)((Object)Details.NONE) + "' is selected, then only the summary and test failures are shown.").withRequiredArg().ofType(Details.class).withValuesConvertedBy(new DetailsConverter()).defaultsTo(CommandLineOptions.DEFAULT_DETAILS, (Details[])new Details[0]);
    private final OptionSpec<Theme> theme = this.parser.accepts("details-theme", "Select an output details tree theme for when tests are executed. Use one of: " + Arrays.asList(Theme.values())).withRequiredArg().ofType(Theme.class).withValuesConvertedBy(new ThemeConverter()).defaultsTo(CommandLineOptions.DEFAULT_THEME, (Theme[])new Theme[0]);
    private final OptionSpec<Path> additionalClasspathEntries = this.parser.acceptsAll(Arrays.asList("cp", "classpath", "class-path"), "Provide additional classpath entries -- for example, for adding engines and their dependencies. This option can be repeated.").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0])).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("path1" + File.pathSeparator + "path2" + File.pathSeparator + "...");
    private final OptionSpec<Path> reportsDir = this.parser.accepts("reports-dir", "Enable report output into a specified local directory (will be created if it does not exist).").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
    private final OptionSpec<Path> selectedClasspathEntries;
    private final OptionSpec<URI> selectedUris;
    private final OptionSpec<String> selectedFiles;
    private final OptionSpec<String> selectedDirectories;
    private final OptionSpec<String> selectedPackages;
    private final OptionSpec<String> selectedClasses;
    private final OptionSpec<String> selectedMethods;
    private final OptionSpec<String> selectedClasspathResources;
    private final OptionSpec<Void> scanModulepath = this.parser.acceptsAll(Arrays.asList("scan-modules"), "EXPERIMENTAL: Scan all resolved modules for test discovery.");
    private final OptionSpec<String> selectedModules = this.parser.acceptsAll(Arrays.asList("o", "select-module"), "EXPERIMENTAL: Select single module for test discovery. This option can be repeated.").withRequiredArg().describedAs("module name");
    private final OptionSpec<String> includeClassNamePattern;
    private final OptionSpec<String> excludeClassNamePattern;
    private final OptionSpec<String> includePackage;
    private final OptionSpec<String> excludePackage;
    private final OptionSpec<String> includeTag;
    private final OptionSpec<String> excludeTag;
    private final OptionSpec<String> includeEngine;
    private final OptionSpec<String> excludeEngine;
    private final OptionSpec<KeyValuePair> configurationParameters;

    AvailableOptions() {
        this.selectedClasspathEntries = this.parser.acceptsAll(Arrays.asList("scan-class-path", "scan-classpath"), "Scan all directories on the classpath or explicit classpath roots. Without arguments, only directories on the system classpath as well as additional classpath entries supplied via -cp (directories and JAR files) are scanned. Explicit classpath roots that are not on the classpath will be silently ignored. This option can be repeated.").withOptionalArg().withValuesConvertedBy(new PathConverter(new PathProperties[0])).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("path1" + File.pathSeparator + "path2" + File.pathSeparator + "...");
        this.selectedUris = this.parser.acceptsAll(Arrays.asList("u", "select-uri"), "Select a URI for test discovery. This option can be repeated.").withRequiredArg().withValuesConvertedBy(new UriConverter());
        this.selectedFiles = this.parser.acceptsAll(Arrays.asList("f", "select-file"), "Select a file for test discovery. This option can be repeated.").withRequiredArg();
        this.selectedDirectories = this.parser.acceptsAll(Arrays.asList("d", "select-directory"), "Select a directory for test discovery. This option can be repeated.").withRequiredArg();
        this.selectedPackages = this.parser.acceptsAll(Arrays.asList("p", "select-package"), "Select a package for test discovery. This option can be repeated.").withRequiredArg();
        this.selectedClasses = this.parser.acceptsAll(Arrays.asList("c", "select-class"), "Select a class for test discovery. This option can be repeated.").withRequiredArg();
        this.selectedMethods = this.parser.acceptsAll(Arrays.asList("m", "select-method"), "Select a method for test discovery. This option can be repeated.").withRequiredArg();
        this.selectedClasspathResources = this.parser.acceptsAll(Arrays.asList("r", "select-resource"), "Select a classpath resource for test discovery. This option can be repeated.").withRequiredArg();
        this.includeClassNamePattern = this.parser.acceptsAll(Arrays.asList("n", "include-classname"), "Provide a regular expression to include only classes whose fully qualified names match. To avoid loading classes unnecessarily, the default pattern only includes class names that begin with \"Test\" or end with \"Test\" or \"Tests\". When this option is repeated, all patterns will be combined using OR semantics.").withRequiredArg().defaultsTo("^(Test.*|.+[.$]Test.*|.*Tests?)$", (String[])new String[0]);
        this.excludeClassNamePattern = this.parser.acceptsAll(Arrays.asList("N", "exclude-classname"), "Provide a regular expression to exclude those classes whose fully qualified names match. When this option is repeated, all patterns will be combined using OR semantics.").withRequiredArg();
        this.includePackage = this.parser.accepts("include-package", "Provide a package to be included in the test run. This option can be repeated.").withRequiredArg();
        this.excludePackage = this.parser.accepts("exclude-package", "Provide a package to be excluded from the test run. This option can be repeated.").withRequiredArg();
        this.includeTag = this.parser.acceptsAll(Arrays.asList("t", "include-tag"), "Provide a tag or tag expression to include only tests whose tags match. When this option is repeated, all patterns will be combined using OR semantics.").withRequiredArg();
        this.excludeTag = this.parser.acceptsAll(Arrays.asList("T", "exclude-tag"), "Provide a tag or tag expression to exclude those tests whose tags match. When this option is repeated, all patterns will be combined using OR semantics.").withRequiredArg();
        this.includeEngine = this.parser.acceptsAll(Arrays.asList("e", "include-engine"), "Provide the ID of an engine to be included in the test run. This option can be repeated.").withRequiredArg();
        this.excludeEngine = this.parser.acceptsAll(Arrays.asList("E", "exclude-engine"), "Provide the ID of an engine to be excluded from the test run. This option can be repeated.").withRequiredArg();
        this.configurationParameters = this.parser.accepts("config", "Set a configuration parameter for test discovery and execution. This option can be repeated.").withRequiredArg().withValuesConvertedBy(new KeyValuePairConverter());
    }

    OptionParser getParser() {
        return this.parser;
    }

    CommandLineOptions toCommandLineOptions(OptionSet detectedOptions) {
        CommandLineOptions result = new CommandLineOptions();
        result.setDisplayHelp(detectedOptions.has(this.help));
        result.setAnsiColorOutputDisabled(detectedOptions.has(this.disableAnsiColors));
        result.setDetails(detectedOptions.valueOf(this.details));
        result.setTheme(detectedOptions.valueOf(this.theme));
        result.setAdditionalClasspathEntries(detectedOptions.valuesOf(this.additionalClasspathEntries));
        result.setReportsDir(detectedOptions.valueOf(this.reportsDir));
        result.setScanModulepath(detectedOptions.has(this.scanModulepath));
        result.setSelectedModules(detectedOptions.valuesOf(this.selectedModules));
        result.setScanClasspath(detectedOptions.has(this.selectedClasspathEntries));
        result.setSelectedClasspathEntries(detectedOptions.valuesOf(this.selectedClasspathEntries));
        result.setSelectedUris(detectedOptions.valuesOf(this.selectedUris));
        result.setSelectedFiles(detectedOptions.valuesOf(this.selectedFiles));
        result.setSelectedDirectories(detectedOptions.valuesOf(this.selectedDirectories));
        result.setSelectedPackages(detectedOptions.valuesOf(this.selectedPackages));
        result.setSelectedClasses(detectedOptions.valuesOf(this.selectedClasses));
        result.setSelectedMethods(detectedOptions.valuesOf(this.selectedMethods));
        result.setSelectedClasspathResources(detectedOptions.valuesOf(this.selectedClasspathResources));
        result.setIncludedClassNamePatterns(detectedOptions.valuesOf(this.includeClassNamePattern));
        result.setExcludedClassNamePatterns(detectedOptions.valuesOf(this.excludeClassNamePattern));
        result.setIncludedPackages(detectedOptions.valuesOf(this.includePackage));
        result.setExcludedPackages(detectedOptions.valuesOf(this.excludePackage));
        result.setIncludedTagExpressions(detectedOptions.valuesOf(this.includeTag));
        result.setExcludedTagExpressions(detectedOptions.valuesOf(this.excludeTag));
        result.setIncludedEngines(detectedOptions.valuesOf(this.includeEngine));
        result.setExcludedEngines(detectedOptions.valuesOf(this.excludeEngine));
        result.setConfigurationParameters(this.toMap(detectedOptions.valuesOf(this.configurationParameters)));
        return result;
    }

    private Map<String, String> toMap(List<KeyValuePair> pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (KeyValuePair pair : pairs) {
            String key = pair.key;
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate key '" + key + "' in: " + pairs);
            }
            map.put(key, pair.value);
        }
        return map;
    }
}

