/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.aggregator;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apiguardian.api.API;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.aggregator.ArgumentsAccessor;
import org.junit.platform.commons.util.AnnotationUtils;

@API(status=API.Status.INTERNAL, since="5.2")
public class AggregationUtils {
    private AggregationUtils() {
    }

    public static boolean hasPotentiallyValidSignature(Method method) {
        Parameter[] parameters = method.getParameters();
        int indexOfPreviousAggregator = -1;
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (!AggregationUtils.isAggregator(parameters[i2])) continue;
            if (indexOfPreviousAggregator != -1 && i2 != indexOfPreviousAggregator + 1) {
                return false;
            }
            indexOfPreviousAggregator = i2;
        }
        return true;
    }

    public static boolean isAggregator(Parameter parameter) {
        return ArgumentsAccessor.class.isAssignableFrom(parameter.getType()) || AnnotationUtils.isAnnotated(parameter, AggregateWith.class);
    }

    public static boolean hasAggregator(Method method) {
        return AggregationUtils.indexOfFirstAggregator(method) != -1;
    }

    public static int indexOfFirstAggregator(Method method) {
        Parameter[] parameters = method.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (!AggregationUtils.isAggregator(parameters[i2])) continue;
            return i2;
        }
        return -1;
    }
}

