/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.aggregator.AggregationUtils;
import org.junit.jupiter.params.aggregator.ArgumentsAggregator;
import org.junit.jupiter.params.aggregator.DefaultArgumentsAccessor;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestParameterResolver
implements ParameterResolver {
    private final Object[] arguments;

    ParameterizedTestParameterResolver(Object[] arguments) {
        this.arguments = arguments;
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Method testMethod;
        Executable declaringExecutable = parameterContext.getDeclaringExecutable();
        if (!declaringExecutable.equals(testMethod = (Method)extensionContext.getTestMethod().orElse(null))) {
            return false;
        }
        if (AggregationUtils.isAggregator(parameterContext.getParameter())) {
            return true;
        }
        int indexOfFirstAggregator = AggregationUtils.indexOfFirstAggregator(testMethod);
        if (indexOfFirstAggregator != -1) {
            return parameterContext.getIndex() < indexOfFirstAggregator;
        }
        return parameterContext.getIndex() < this.arguments.length;
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return AggregationUtils.isAggregator(parameterContext.getParameter()) ? this.aggregate(parameterContext, extensionContext) : this.convert(parameterContext, extensionContext);
    }

    private Object convert(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Object argument = this.arguments[parameterContext.getIndex()];
        Optional<ConvertWith> annotation = AnnotationUtils.findAnnotation(parameter, ConvertWith.class);
        ArgumentConverter argumentConverter = annotation.map(ConvertWith::value).map(clazz -> (ArgumentConverter)ReflectionUtils.newInstance(clazz, new Object[0])).map(converter -> AnnotationConsumerInitializer.initialize(parameter, converter)).orElse(DefaultArgumentConverter.INSTANCE);
        try {
            return argumentConverter.convert(argument, parameterContext);
        }
        catch (Exception ex) {
            String message = "Error resolving parameter at index " + parameterContext.getIndex();
            if (StringUtils.isNotBlank(ex.getMessage())) {
                message = message + ": " + ex.getMessage();
            }
            throw new ParameterResolutionException(message, ex);
        }
    }

    private Object aggregate(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Optional<AggregateWith> annotation = AnnotationUtils.findAnnotation(parameter, AggregateWith.class);
        DefaultArgumentsAccessor accessor = new DefaultArgumentsAccessor(this.arguments);
        try {
            return annotation.map(AggregateWith::value).map(clazz -> (ArgumentsAggregator)ReflectionUtils.newInstance(clazz, new Object[0])).map(aggregator -> aggregator.aggregateArguments(accessor, parameterContext)).orElse(accessor);
        }
        catch (Exception ex) {
            String message = "Error aggregating arguments for parameter at index " + parameterContext.getIndex();
            if (StringUtils.isNotBlank(ex.getMessage())) {
                message = message + ": " + ex.getMessage();
            }
            throw new ParameterResolutionException(message, ex);
        }
    }
}

