/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;

class CompositeLauncherDiscoveryListener
implements LauncherDiscoveryListener {
    private final List<LauncherDiscoveryListener> listeners;

    CompositeLauncherDiscoveryListener(List<LauncherDiscoveryListener> listeners) {
        this.listeners = Collections.unmodifiableList(new ArrayList<LauncherDiscoveryListener>(listeners));
    }

    @Override
    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        this.listeners.forEach(delegate -> delegate.launcherDiscoveryStarted(request));
    }

    @Override
    public void launcherDiscoveryFinished(LauncherDiscoveryRequest request) {
        CollectionUtils.forEachInReverseOrder(this.listeners, delegate -> delegate.launcherDiscoveryFinished(request));
    }

    @Override
    public void engineDiscoveryStarted(UniqueId engineId) {
        this.listeners.forEach(delegate -> delegate.engineDiscoveryStarted(engineId));
    }

    @Override
    public void engineDiscoveryFinished(UniqueId engineId, EngineDiscoveryResult result) {
        CollectionUtils.forEachInReverseOrder(this.listeners, delegate -> delegate.engineDiscoveryFinished(engineId, result));
    }

    @Override
    public void selectorProcessed(UniqueId engineId, DiscoverySelector selector, SelectorResolutionResult result) {
        this.listeners.forEach(delegate -> delegate.selectorProcessed(engineId, selector, result));
    }

    @Override
    public void issueEncountered(UniqueId engineId, DiscoveryIssue issue) {
        this.listeners.forEach(delegate -> delegate.issueEncountered(engineId, issue));
    }
}

