/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ArgumentCountValidationMode;
import org.junit.jupiter.params.EvaluatedArgumentSet;
import org.junit.jupiter.params.ParameterizedDeclarationContext;
import org.junit.jupiter.params.ResolverFacade;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;

class ArgumentCountValidator {
    private static final Logger logger = LoggerFactory.getLogger(ArgumentCountValidator.class);
    static final String ARGUMENT_COUNT_VALIDATION_KEY = "junit.jupiter.params.argumentCountValidation";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(ArgumentCountValidator.class);
    private final ParameterizedDeclarationContext<?> declarationContext;
    private final EvaluatedArgumentSet arguments;

    ArgumentCountValidator(ParameterizedDeclarationContext<?> declarationContext, EvaluatedArgumentSet arguments) {
        this.declarationContext = declarationContext;
        this.arguments = arguments;
    }

    void validate(ExtensionContext extensionContext) {
        this.validateRequiredArgumentsArePresent();
        ArgumentCountValidationMode argumentCountValidationMode = this.getArgumentCountValidationMode(extensionContext);
        switch (argumentCountValidationMode) {
            case DEFAULT: 
            case NONE: {
                return;
            }
            case STRICT: {
                int consumedCount = this.declarationContext.getResolverFacade().determineConsumedArgumentCount(this.arguments);
                int totalCount = this.arguments.getTotalLength();
                Preconditions.condition(consumedCount == totalCount, () -> this.wrongNumberOfArgumentsMessages("consumes", consumedCount, null, null));
                break;
            }
            default: {
                throw new ExtensionConfigurationException("Unsupported argument count validation mode: " + (Object)((Object)argumentCountValidationMode));
            }
        }
    }

    private void validateRequiredArgumentsArePresent() {
        ResolverFacade.RequiredParameterCount requiredParameterCount = this.declarationContext.getResolverFacade().getRequiredParameterCount();
        if (requiredParameterCount != null) {
            int totalCount = this.arguments.getTotalLength();
            Preconditions.condition(requiredParameterCount.value() <= totalCount, () -> this.wrongNumberOfArgumentsMessages("has", requiredParameterCount.value(), "required", requiredParameterCount.reason()));
        }
    }

    private String wrongNumberOfArgumentsMessages(String verb, int actualCount, String parameterAdjective, String reason) {
        int totalCount = this.arguments.getTotalLength();
        return String.format("Configuration error: @%s %s %s %s%s%s but there %s %s %s provided.%nNote: the provided arguments were %s", this.declarationContext.getAnnotationName(), verb, actualCount, parameterAdjective == null ? "" : parameterAdjective + " ", ArgumentCountValidator.pluralize(actualCount, "parameter", "parameters"), reason == null ? "" : String.format(" (due to %s)", reason), ArgumentCountValidator.pluralize(totalCount, "was", "were"), totalCount, ArgumentCountValidator.pluralize(totalCount, "argument", "arguments"), Arrays.toString(this.arguments.getAllPayloads()));
    }

    private ArgumentCountValidationMode getArgumentCountValidationMode(ExtensionContext extensionContext) {
        ArgumentCountValidationMode mode = this.declarationContext.getArgumentCountValidationMode();
        if (mode != ArgumentCountValidationMode.DEFAULT) {
            return mode;
        }
        return this.getArgumentCountValidationModeConfiguration(extensionContext);
    }

    private ArgumentCountValidationMode getArgumentCountValidationModeConfiguration(ExtensionContext extensionContext) {
        String key = ARGUMENT_COUNT_VALIDATION_KEY;
        ArgumentCountValidationMode fallback = ArgumentCountValidationMode.NONE;
        ExtensionContext.Store store = this.getStore(extensionContext);
        return store.getOrComputeIfAbsent(key, __ -> {
            Optional<String> optionalConfigValue = extensionContext.getConfigurationParameter(key);
            if (optionalConfigValue.isPresent()) {
                String configValue = optionalConfigValue.get();
                Optional<ArgumentCountValidationMode> enumValue = Arrays.stream(ArgumentCountValidationMode.values()).filter(mode -> mode.name().equalsIgnoreCase(configValue)).findFirst();
                if (enumValue.isPresent()) {
                    logger.config(() -> String.format("Using ArgumentCountValidationMode '%s' set via the '%s' configuration parameter.", ((ArgumentCountValidationMode)((Object)((Object)((Object)enumValue.get())))).name(), key));
                    return enumValue.get();
                }
                logger.warn(() -> String.format("Invalid ArgumentCountValidationMode '%s' set via the '%s' configuration parameter. Falling back to the %s default value.", configValue, key, fallback.name()));
                return fallback;
            }
            return fallback;
        }, ArgumentCountValidationMode.class);
    }

    private static String pluralize(int count, String singular, String plural) {
        return count == 1 ? singular : plural;
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

