/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.engine.extension.ExtensionRegistrar;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

final class ExtensionUtils {
    private static final Comparator<Field> orderComparator = Comparator.comparingInt(ExtensionUtils::getOrder);
    private static final Predicate<Field> registersExtension = field -> AnnotationSupport.isAnnotated(field, RegisterExtension.class) || !AnnotationUtils.findRepeatableAnnotations(field, ExtendWith.class).isEmpty();

    private ExtensionUtils() {
    }

    static MutableExtensionRegistry populateNewExtensionRegistryFromExtendWithAnnotation(MutableExtensionRegistry parentRegistry, AnnotatedElement annotatedElement) {
        Preconditions.notNull(parentRegistry, "Parent ExtensionRegistry must not be null");
        Preconditions.notNull(annotatedElement, "AnnotatedElement must not be null");
        return MutableExtensionRegistry.createRegistryFrom(parentRegistry, ExtensionUtils.streamDeclarativeExtensionTypes(annotatedElement));
    }

    static void registerExtensionsFromStaticFields(ExtensionRegistrar registrar, Class<?> clazz) {
        ExtensionUtils.streamExtensionRegisteringFields(clazz, ModifierSupport::isStatic).forEach(field -> {
            boolean isExtendWithPresent;
            List<Class<? extends Extension>> extensionTypes = ExtensionUtils.streamDeclarativeExtensionTypes(field).collect(Collectors.toList());
            boolean bl = isExtendWithPresent = !extensionTypes.isEmpty();
            if (isExtendWithPresent) {
                extensionTypes.forEach(registrar::registerExtension);
            }
            if (AnnotationSupport.isAnnotated(field, RegisterExtension.class)) {
                Extension extension = ExtensionUtils.readAndValidateExtensionFromField(field, null, extensionTypes);
                registrar.registerExtension(extension, field);
            }
        });
    }

    static void registerExtensionsFromInstanceFields(ExtensionRegistrar registrar, Class<?> clazz) {
        ExtensionUtils.streamExtensionRegisteringFields(clazz, ReflectionUtils::isNotStatic).forEach(field -> {
            boolean isExtendWithPresent;
            List<Class> extensionTypes = ExtensionUtils.streamDeclarativeExtensionTypes(field).collect(Collectors.toList());
            boolean bl = isExtendWithPresent = !extensionTypes.isEmpty();
            if (isExtendWithPresent) {
                extensionTypes.forEach(registrar::registerExtension);
            }
            if (AnnotationSupport.isAnnotated(field, RegisterExtension.class)) {
                registrar.registerUninitializedExtension(clazz, (Field)field, instance -> ExtensionUtils.readAndValidateExtensionFromField(field, instance, extensionTypes));
            }
        });
    }

    private static Extension readAndValidateExtensionFromField(Field field, Object instance, List<Class<? extends Extension>> declarativeExtensionTypes) {
        Object value = ReflectionUtils.tryToReadFieldValue(field, instance).getOrThrow(e -> new PreconditionViolationException(String.format("Failed to read @RegisterExtension field [%s]", field), (Throwable)e));
        Preconditions.condition(value instanceof Extension, () -> String.format("Failed to register extension via @RegisterExtension field [%s]: field value's type [%s] must implement an [%s] API.", field, value != null ? value.getClass().getName() : null, Extension.class.getName()));
        declarativeExtensionTypes.forEach(extensionType -> {
            Class<?> valueType = value.getClass();
            Preconditions.condition(!extensionType.equals(valueType), () -> String.format("Failed to register extension via field [%s]. The field registers an extension of type [%s] via @RegisterExtension and @ExtendWith, but only one registration of a given extension type is permitted.", field, valueType.getName()));
        });
        return (Extension)value;
    }

    static void registerExtensionsFromConstructorParameters(ExtensionRegistrar registrar, Class<?> clazz) {
        ExtensionUtils.registerExtensionsFromExecutableParameters(registrar, ReflectionUtils.getDeclaredConstructor(clazz));
    }

    static void registerExtensionsFromExecutableParameters(ExtensionRegistrar registrar, Executable executable) {
        Preconditions.notNull(registrar, "ExtensionRegistrar must not be null");
        Preconditions.notNull(executable, "Executable must not be null");
        AtomicInteger index = new AtomicInteger();
        Arrays.stream(executable.getParameters()).map(parameter -> AnnotationUtils.findRepeatableAnnotations(parameter, index.getAndIncrement(), ExtendWith.class)).flatMap(ExtensionUtils::streamDeclarativeExtensionTypes).forEach(registrar::registerExtension);
    }

    private static Stream<Field> streamExtensionRegisteringFields(Class<?> clazz, Predicate<Field> predicate) {
        return ReflectionUtils.streamFields(clazz, predicate.and(registersExtension), ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).sorted(orderComparator);
    }

    private static Stream<Class<? extends Extension>> streamDeclarativeExtensionTypes(AnnotatedElement annotatedElement) {
        return ExtensionUtils.streamDeclarativeExtensionTypes(AnnotationUtils.findRepeatableAnnotations(annotatedElement, ExtendWith.class));
    }

    private static Stream<Class<? extends Extension>> streamDeclarativeExtensionTypes(List<ExtendWith> extendWithAnnotations) {
        return extendWithAnnotations.stream().map(ExtendWith::value).flatMap(Arrays::stream);
    }

    private static int getOrder(Field field) {
        return AnnotationSupport.findAnnotation(field, Order.class).map(Order::value).orElse(0x3FFFFFFF);
    }
}

