/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.MediaType;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.execution.DefaultExecutableInvoker;
import org.junit.jupiter.engine.execution.LauncherStoreFacade;
import org.junit.jupiter.engine.extension.ExtensionContextInternal;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

abstract class AbstractExtensionContext<T extends TestDescriptor>
implements ExtensionContextInternal,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExtensionContext.class);
    private static final ExtensionContext.Namespace CLOSEABLE_RESOURCE_LOGGING_NAMESPACE = ExtensionContext.Namespace.create(AbstractExtensionContext.class, "CloseableResourceLogging");
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final T testDescriptor;
    private final Set<String> tags;
    private final JupiterConfiguration configuration;
    private final ExecutableInvoker executableInvoker;
    private final ExtensionRegistry extensionRegistry;
    private final LauncherStoreFacade launcherStoreFacade;
    private final NamespacedHierarchicalStore<Namespace> valuesStore;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, T testDescriptor, JupiterConfiguration configuration, ExtensionRegistry extensionRegistry, LauncherStoreFacade launcherStoreFacade) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        Preconditions.notNull(configuration, "JupiterConfiguration must not be null");
        Preconditions.notNull(extensionRegistry, "ExtensionRegistry must not be null");
        this.executableInvoker = new DefaultExecutableInvoker(this, extensionRegistry);
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.configuration = configuration;
        this.extensionRegistry = extensionRegistry;
        this.launcherStoreFacade = launcherStoreFacade;
        this.tags = testDescriptor.getTags().stream().map(TestTag::getName).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
        this.valuesStore = new NamespacedHierarchicalStore<Namespace>(this.getParentStore(parent), this.createCloseAction());
    }

    private NamespacedHierarchicalStore<Namespace> getParentStore(ExtensionContext parent) {
        return parent == null ? this.launcherStoreFacade.getRequestLevelStore() : ((AbstractExtensionContext)parent).valuesStore;
    }

    private <N> NamespacedHierarchicalStore.CloseAction<N> createCloseAction() {
        ExtensionContext.Store store = this.launcherStoreFacade.getSessionLevelStore(CLOSEABLE_RESOURCE_LOGGING_NAMESPACE);
        return (__, ___, value) -> {
            boolean isAutoCloseEnabled = this.configuration.isClosingStoredAutoCloseablesEnabled();
            if (isAutoCloseEnabled && value instanceof AutoCloseable) {
                ((AutoCloseable)value).close();
                return;
            }
            if (value instanceof ExtensionContext.Store.CloseableResource) {
                if (isAutoCloseEnabled) {
                    store.getOrComputeIfAbsent(value.getClass(), type -> {
                        LOGGER.warn(() -> "Type implements CloseableResource but not AutoCloseable: " + type.getName());
                        return true;
                    });
                }
                ((ExtensionContext.Store.CloseableResource)value).close();
            }
        };
    }

    @Override
    public void close() {
        this.valuesStore.close();
    }

    @Override
    public String getUniqueId() {
        return this.getTestDescriptor().getUniqueId().toString();
    }

    @Override
    public String getDisplayName() {
        return this.getTestDescriptor().getDisplayName();
    }

    @Override
    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished((TestDescriptor)this.testDescriptor, ReportEntry.from(values));
    }

    @Override
    public void publishFile(String name, MediaType mediaType, ThrowingConsumer<Path> action) {
        Preconditions.notBlank(name, "name must not be null or blank");
        Preconditions.notNull(mediaType, "mediaType must not be null");
        Preconditions.notNull(action, "action must not be null");
        this.publishFileEntry(name, action, path -> {
            Preconditions.condition(Files.isRegularFile(path, new LinkOption[0]), () -> "Published path must be a regular file: " + path);
            return FileEntry.from(path, mediaType.toString());
        });
    }

    @Override
    public void publishDirectory(String name, ThrowingConsumer<Path> action) {
        Preconditions.notBlank(name, "name must not be null or blank");
        Preconditions.notNull(action, "action must not be null");
        ThrowingConsumer<Path> enhancedAction = path -> {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            action.accept((Path)path);
        };
        this.publishFileEntry(name, enhancedAction, path -> {
            Preconditions.condition(Files.isDirectory(path, new LinkOption[0]), () -> "Published path must be a directory: " + path);
            return FileEntry.from(path, null);
        });
    }

    private void publishFileEntry(String name, ThrowingConsumer<Path> action, Function<Path, FileEntry> fileEntryCreator) {
        Path dir = this.createOutputDirectory();
        Path path = dir.resolve(name);
        Preconditions.condition(path.getParent().equals(dir), () -> "name must not contain path separators: " + name);
        try {
            action.accept(path);
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            throw new JUnitException("Failed to publish path", t);
        }
        Preconditions.condition(Files.exists(path, new LinkOption[0]), () -> "Published path must exist: " + path);
        FileEntry fileEntry = fileEntryCreator.apply(path);
        this.engineExecutionListener.fileEntryPublished((TestDescriptor)this.testDescriptor, fileEntry);
    }

    private Path createOutputDirectory() {
        try {
            return this.configuration.getOutputDirectoryCreator().createOutputDirectory((TestDescriptor)this.testDescriptor);
        }
        catch (IOException e) {
            throw new JUnitException("Failed to create output directory", e);
        }
    }

    @Override
    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public ExtensionContext getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected T getTestDescriptor() {
        return this.testDescriptor;
    }

    @Override
    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        return this.launcherStoreFacade.getStoreAdapter(this.valuesStore, namespace);
    }

    @Override
    public ExtensionContext.Store getStore(ExtensionContext.StoreScope scope, ExtensionContext.Namespace namespace) {
        switch (scope) {
            case LAUNCHER_SESSION: {
                return this.launcherStoreFacade.getSessionLevelStore(namespace);
            }
            case EXECUTION_REQUEST: {
                return this.launcherStoreFacade.getRequestLevelStore(namespace);
            }
            case EXTENSION_CONTEXT: {
                return this.getStore(namespace);
            }
        }
        throw new JUnitException("Unknown StoreScope: " + (Object)((Object)scope));
    }

    @Override
    public Set<String> getTags() {
        return new LinkedHashSet<String>(this.tags);
    }

    @Override
    public Optional<String> getConfigurationParameter(String key) {
        return this.configuration.getRawConfigurationParameter(key);
    }

    public <V> Optional<V> getConfigurationParameter(String key, Function<String, V> transformer) {
        return this.configuration.getRawConfigurationParameter(key, transformer);
    }

    @Override
    public ExecutionMode getExecutionMode() {
        return this.toJupiterExecutionMode(this.getPlatformExecutionMode());
    }

    @Override
    public ExecutableInvoker getExecutableInvoker() {
        return this.executableInvoker;
    }

    @Override
    public <E extends Extension> List<E> getExtensions(Class<E> extensionType) {
        return this.extensionRegistry.getExtensions(extensionType);
    }

    protected abstract Node.ExecutionMode getPlatformExecutionMode();

    private ExecutionMode toJupiterExecutionMode(Node.ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return ExecutionMode.SAME_THREAD;
            }
        }
        throw new JUnitException("Unknown ExecutionMode: " + (Object)((Object)mode));
    }
}

