/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="5.14")
public class MediaType {
    private static final Pattern PATTERN;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType TEXT_PLAIN_UTF_8;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType IMAGE_JPEG;
    public static final MediaType IMAGE_PNG;
    private final String value;

    public static MediaType parse(String value) {
        return new MediaType(value);
    }

    public static MediaType create(String type, String subtype) {
        return new MediaType(type, subtype, null);
    }

    public static MediaType create(String type, String subtype, Charset charset) {
        Preconditions.notNull(charset, "charset must not be null");
        return new MediaType(type, subtype, charset);
    }

    protected MediaType(String type, String subtype, Charset charset) {
        this(String.format("%s/%s%s", Preconditions.notBlank(type, "type must not be null or blank").trim(), Preconditions.notBlank(subtype, "subtype must not be null or blank").trim(), charset != null ? "; charset=" + charset.name() : ""));
    }

    protected MediaType(String value) {
        if (this.getClass() != MediaType.class && !this.getClass().getName().equals("org.junit.jupiter.api.extension.MediaType")) {
            throw new IllegalStateException(String.format("Type '%s' is not permitted to extend MediaType", this.getClass().getName()));
        }
        String trimmedValue = Preconditions.notBlank(value, "value must not be null or blank").trim();
        Matcher matcher = PATTERN.matcher(trimmedValue);
        Preconditions.condition(matcher.matches(), () -> "Invalid media type: '" + trimmedValue + "'");
        this.value = trimmedValue;
    }

    public final String toString() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MediaType) {
            MediaType that = (MediaType)obj;
            return this.value.equals(that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.value);
    }

    static {
        String whitespace = "[ \t]*";
        String token = "[0-9A-Za-z!#$%&'*+.^_`|~-]+";
        String quotedString = "\"(?:[^\"\\\\]|\\.)*\"";
        String parameter = ";" + whitespace + token + "=(?:" + token + "|" + quotedString + ")";
        PATTERN = Pattern.compile(token + "/" + token + "(?:" + whitespace + parameter + ")*");
        TEXT_PLAIN = MediaType.create("text", "plain");
        TEXT_PLAIN_UTF_8 = MediaType.create("text", "plain", StandardCharsets.UTF_8);
        APPLICATION_JSON = MediaType.create("application", "json");
        APPLICATION_OCTET_STREAM = MediaType.create("application", "octet-stream");
        IMAGE_JPEG = MediaType.create("image", "jpeg");
        IMAGE_PNG = MediaType.create("image", "png");
    }
}

