/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.command;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.console.command.CustomClassLoaderCloseStrategy;
import org.junit.platform.console.command.CustomContextClassLoaderExecutor;
import org.junit.platform.console.command.DiscoveryRequestCreator;
import org.junit.platform.console.command.StandardStreamsHandler;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.TestConsoleOutputOptions;
import org.junit.platform.console.options.TestDiscoveryOptions;
import org.junit.platform.console.output.ColorPalette;
import org.junit.platform.console.output.DetailsPrintingListener;
import org.junit.platform.console.output.FlatPrintingListener;
import org.junit.platform.console.output.TestFeedPrintingListener;
import org.junit.platform.console.output.Theme;
import org.junit.platform.console.output.TreePrintingListener;
import org.junit.platform.console.output.VerboseTreePrintingListener;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;

@API(status=API.Status.INTERNAL, since="1.0")
public class ConsoleTestExecutor {
    private final TestDiscoveryOptions discoveryOptions;
    private final TestConsoleOutputOptions outputOptions;
    private final Supplier<Launcher> launcherSupplier;
    private final CustomClassLoaderCloseStrategy classLoaderCloseStrategy;

    public ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions) {
        this(discoveryOptions, outputOptions, CustomClassLoaderCloseStrategy.CLOSE_AFTER_CALLING_LAUNCHER);
    }

    public ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, CustomClassLoaderCloseStrategy classLoaderCloseStrategy) {
        this(discoveryOptions, outputOptions, classLoaderCloseStrategy, LauncherFactory::create);
    }

    ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, Supplier<Launcher> launcherSupplier) {
        this(discoveryOptions, outputOptions, CustomClassLoaderCloseStrategy.CLOSE_AFTER_CALLING_LAUNCHER, launcherSupplier);
    }

    private ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, CustomClassLoaderCloseStrategy classLoaderCloseStrategy, Supplier<Launcher> launcherSupplier) {
        this.discoveryOptions = discoveryOptions;
        this.outputOptions = outputOptions;
        this.launcherSupplier = launcherSupplier;
        this.classLoaderCloseStrategy = classLoaderCloseStrategy;
    }

    public void discover(PrintWriter out) {
        this.createCustomContextClassLoaderExecutor().invoke(() -> {
            this.discoverTests(out);
            return null;
        });
    }

    public TestExecutionSummary execute(PrintWriter out, Optional<Path> reportsDir) {
        return this.createCustomContextClassLoaderExecutor().invoke(() -> this.executeTests(out, reportsDir));
    }

    private CustomContextClassLoaderExecutor createCustomContextClassLoaderExecutor() {
        return new CustomContextClassLoaderExecutor(this.createCustomClassLoader(), this.classLoaderCloseStrategy);
    }

    private void discoverTests(PrintWriter out) {
        Launcher launcher = this.launcherSupplier.get();
        Optional<DetailsPrintingListener> commandLineTestPrinter = this.createDetailsPrintingListener(out);
        LauncherDiscoveryRequest discoveryRequest = DiscoveryRequestCreator.toDiscoveryRequestBuilder(this.discoveryOptions).build();
        TestPlan testPlan = launcher.discover(discoveryRequest);
        commandLineTestPrinter.ifPresent(printer -> printer.listTests(testPlan));
        if (this.outputOptions.getDetails() != Details.NONE) {
            ConsoleTestExecutor.printFoundTestsSummary(out, testPlan);
        }
    }

    private static void printFoundTestsSummary(PrintWriter out, TestPlan testPlan) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        summaryListener.testPlanExecutionStarted(testPlan);
        TestExecutionSummary summary = summaryListener.getSummary();
        out.printf("%n[%10d containers found ]%n[%10d tests found      ]%n%n", summary.getContainersFoundCount(), summary.getTestsFoundCount());
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestExecutionSummary executeTests(PrintWriter out, Optional<Path> reportsDir) {
        Launcher launcher = this.launcherSupplier.get();
        SummaryGeneratingListener summaryListener = this.registerListeners(out, reportsDir, launcher);
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        try (StandardStreamsHandler standardStreamsHandler = new StandardStreamsHandler();){
            standardStreamsHandler.redirectStandardStreams(this.outputOptions.getStdoutPath(), this.outputOptions.getStderrPath());
            this.launchTests(launcher, reportsDir);
        }
        finally {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        TestExecutionSummary summary = summaryListener.getSummary();
        if (summary.getTotalFailureCount() > 0L || this.outputOptions.getDetails() != Details.NONE) {
            this.printSummary(summary, out);
        }
        return summary;
    }

    private void launchTests(Launcher launcher, Optional<Path> reportsDir) {
        LauncherDiscoveryRequestBuilder discoveryRequestBuilder = DiscoveryRequestCreator.toDiscoveryRequestBuilder(this.discoveryOptions);
        reportsDir.ifPresent(dir -> discoveryRequestBuilder.configurationParameter("junit.platform.reporting.output.dir", dir.toAbsolutePath().toString()));
        launcher.execute(discoveryRequestBuilder.build(), new TestExecutionListener[0]);
    }

    private Optional<ClassLoader> createCustomClassLoader() {
        List<Path> additionalClasspathEntries = this.discoveryOptions.getExistingAdditionalClasspathEntries();
        if (!additionalClasspathEntries.isEmpty()) {
            URL[] urls = (URL[])additionalClasspathEntries.stream().map(this::toURL).toArray(URL[]::new);
            ClassLoader parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
            URLClassLoader customClassLoader = URLClassLoader.newInstance(urls, parentClassLoader);
            return Optional.of(customClassLoader);
        }
        return Optional.empty();
    }

    private URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (Exception ex) {
            throw new JUnitException("Invalid classpath entry: " + path, ex);
        }
    }

    private SummaryGeneratingListener registerListeners(PrintWriter out, Optional<Path> reportsDir, Launcher launcher) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(summaryListener);
        this.createDetailsPrintingListener(out).ifPresent(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        this.createXmlWritingListener(out, reportsDir).ifPresent(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        return summaryListener;
    }

    private Optional<DetailsPrintingListener> createDetailsPrintingListener(PrintWriter out) {
        ColorPalette colorPalette = this.getColorPalette();
        Theme theme = this.outputOptions.getTheme();
        switch (this.outputOptions.getDetails()) {
            case SUMMARY: {
                return Optional.empty();
            }
            case FLAT: {
                return Optional.of(new FlatPrintingListener(out, colorPalette));
            }
            case TREE: {
                return Optional.of(new TreePrintingListener(out, colorPalette, theme));
            }
            case VERBOSE: {
                return Optional.of(new VerboseTreePrintingListener(out, colorPalette, 16, theme));
            }
            case TESTFEED: {
                return Optional.of(new TestFeedPrintingListener(out, colorPalette));
            }
        }
        return Optional.empty();
    }

    private ColorPalette getColorPalette() {
        if (this.outputOptions.isAnsiColorOutputDisabled()) {
            return ColorPalette.NONE;
        }
        if (this.outputOptions.getColorPalettePath() != null) {
            return new ColorPalette(this.outputOptions.getColorPalettePath());
        }
        if (this.outputOptions.isSingleColorPalette()) {
            return ColorPalette.SINGLE_COLOR;
        }
        return ColorPalette.DEFAULT;
    }

    private Optional<TestExecutionListener> createXmlWritingListener(PrintWriter out, Optional<Path> reportsDir) {
        return reportsDir.map(it -> new LegacyXmlReportGeneratingListener((Path)it, out));
    }

    private void printSummary(TestExecutionSummary summary, PrintWriter out) {
        if (EnumSet.of(Details.NONE, Details.SUMMARY, Details.TREE).contains((Object)this.outputOptions.getDetails())) {
            summary.printFailuresTo(out);
        }
        summary.printTo(out);
    }

    @FunctionalInterface
    public static interface Factory {
        public ConsoleTestExecutor create(TestDiscoveryOptions var1, TestConsoleOutputOptions var2);
    }
}

