/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.platform.commons.util.ToStringBuilder;

class TestInfoParameterResolver
implements ParameterResolver {
    TestInfoParameterResolver() {
    }

    @Override
    public TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == TestInfo.class;
    }

    @Override
    public TestInfo resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return new DefaultTestInfo(extensionContext);
    }

    private static class DefaultTestInfo
    implements TestInfo {
        private final String displayName;
        private final Set<String> tags;
        private final Optional<Class<?>> testClass;
        private final Optional<Method> testMethod;

        DefaultTestInfo(ExtensionContext extensionContext) {
            this.displayName = extensionContext.getDisplayName();
            this.tags = extensionContext.getTags();
            this.testClass = extensionContext.getTestClass();
            this.testMethod = extensionContext.getTestMethod();
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Set<String> getTags() {
            return this.tags;
        }

        @Override
        public Optional<Class<?>> getTestClass() {
            return this.testClass;
        }

        @Override
        public Optional<Method> getTestMethod() {
            return this.testMethod;
        }

        public String toString() {
            return new ToStringBuilder(this).append("displayName", this.displayName).append("tags", this.tags).append("testClass", DefaultTestInfo.nullSafeGet(this.testClass)).append("testMethod", DefaultTestInfo.nullSafeGet(this.testMethod)).toString();
        }

        private static Object nullSafeGet(Optional<?> optional) {
            return optional != null ? optional.orElse(null) : null;
        }
    }
}

