/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="5.7")
public interface Arguments {
    public Object[] get();

    public static Arguments of(Object ... arguments) {
        Preconditions.notNull(arguments, "arguments array must not be null");
        return () -> arguments;
    }

    public static Arguments arguments(Object ... arguments) {
        return Arguments.of(arguments);
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public static ArgumentSet argumentSet(String name, Object ... arguments) {
        return new ArgumentSet(name, arguments);
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public static final class ArgumentSet
    implements Arguments {
        private final String name;
        private final Object[] arguments;

        private ArgumentSet(String name, Object[] arguments) {
            Preconditions.notBlank(name, "name must not be null or blank");
            Preconditions.notNull(arguments, "arguments array must not be null");
            this.name = name;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Object[] get() {
            return this.arguments;
        }

        public String toString() {
            return this.getName();
        }
    }
}

